/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIPAM;
import io.fabric8.docker.api.model.IPAM;
import io.fabric8.docker.api.model.IPAMFluent;
import io.fabric8.docker.api.model.IPAMFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IPAMBuilder
extends IPAMFluentImpl<IPAMBuilder>
implements VisitableBuilder<IPAM, IPAMBuilder> {
    IPAMFluent<?> fluent;

    public IPAMBuilder() {
        this(new IPAM());
    }

    public IPAMBuilder(IPAMFluent<?> fluent) {
        this(fluent, new IPAM());
    }

    public IPAMBuilder(IPAMFluent<?> fluent, IPAM instance) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withDriver(instance.getDriver());
    }

    public IPAMBuilder(IPAM instance) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withDriver(instance.getDriver());
    }

    @Override
    public EditableIPAM build() {
        EditableIPAM buildable = new EditableIPAM(this.fluent.getConfig(), this.fluent.getDriver());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAMBuilder that = (IPAMBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

