/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableExecStartCheck;
import io.fabric8.docker.api.model.ExecStartCheck;
import io.fabric8.docker.api.model.ExecStartCheckFluent;
import io.fabric8.docker.api.model.ExecStartCheckFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ExecStartCheckBuilder
extends ExecStartCheckFluentImpl<ExecStartCheckBuilder>
implements VisitableBuilder<ExecStartCheck, ExecStartCheckBuilder> {
    ExecStartCheckFluent<?> fluent;

    public ExecStartCheckBuilder() {
        this(new ExecStartCheck());
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent) {
        this(fluent, new ExecStartCheck());
    }

    public ExecStartCheckBuilder(ExecStartCheckFluent<?> fluent, ExecStartCheck instance) {
        this.fluent = fluent;
        fluent.withDetach(instance.getDetach());
        fluent.withTty(instance.getTty());
    }

    public ExecStartCheckBuilder(ExecStartCheck instance) {
        this.fluent = this;
        this.withDetach(instance.getDetach());
        this.withTty(instance.getTty());
    }

    @Override
    public EditableExecStartCheck build() {
        EditableExecStartCheck buildable = new EditableExecStartCheck(this.fluent.isDetach(), this.fluent.isTty());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecStartCheckBuilder that = (ExecStartCheckBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

