/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerCreateResponse;
import io.fabric8.docker.api.model.ContainerCreateResponseFluent;
import io.fabric8.docker.api.model.ContainerCreateResponseFluentImpl;
import io.fabric8.docker.api.model.EditableContainerCreateResponse;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerCreateResponseBuilder
extends ContainerCreateResponseFluentImpl<ContainerCreateResponseBuilder>
implements VisitableBuilder<ContainerCreateResponse, ContainerCreateResponseBuilder> {
    ContainerCreateResponseFluent<?> fluent;

    public ContainerCreateResponseBuilder() {
        this(new ContainerCreateResponse());
    }

    public ContainerCreateResponseBuilder(ContainerCreateResponseFluent<?> fluent) {
        this(fluent, new ContainerCreateResponse());
    }

    public ContainerCreateResponseBuilder(ContainerCreateResponseFluent<?> fluent, ContainerCreateResponse instance) {
        this.fluent = fluent;
        fluent.withId(instance.getId());
        fluent.withWarnings(instance.getWarnings());
    }

    public ContainerCreateResponseBuilder(ContainerCreateResponse instance) {
        this.fluent = this;
        this.withId(instance.getId());
        this.withWarnings(instance.getWarnings());
    }

    @Override
    public EditableContainerCreateResponse build() {
        EditableContainerCreateResponse buildable = new EditableContainerCreateResponse(this.fluent.getId(), this.fluent.getWarnings());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerCreateResponseBuilder that = (ContainerCreateResponseBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

