/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CPUUsage;
import io.fabric8.docker.api.model.CPUUsageFluent;
import io.fabric8.docker.api.model.CPUUsageFluentImpl;
import io.fabric8.docker.api.model.EditableCPUUsage;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CPUUsageBuilder
extends CPUUsageFluentImpl<CPUUsageBuilder>
implements VisitableBuilder<CPUUsage, CPUUsageBuilder> {
    CPUUsageFluent<?> fluent;

    public CPUUsageBuilder() {
        this(new CPUUsage());
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent) {
        this(fluent, new CPUUsage());
    }

    public CPUUsageBuilder(CPUUsageFluent<?> fluent, CPUUsage instance) {
        this.fluent = fluent;
        fluent.withPercpuUsage(instance.getPercpuUsage());
        fluent.withTotalUsage(instance.getTotalUsage());
        fluent.withUsageInKernelmode(instance.getUsageInKernelmode());
        fluent.withUsageInUsermode(instance.getUsageInUsermode());
    }

    public CPUUsageBuilder(CPUUsage instance) {
        this.fluent = this;
        this.withPercpuUsage(instance.getPercpuUsage());
        this.withTotalUsage(instance.getTotalUsage());
        this.withUsageInKernelmode(instance.getUsageInKernelmode());
        this.withUsageInUsermode(instance.getUsageInUsermode());
    }

    @Override
    public EditableCPUUsage build() {
        EditableCPUUsage buildable = new EditableCPUUsage(this.fluent.getPercpuUsage(), this.fluent.getTotalUsage(), this.fluent.getUsageInKernelmode(), this.fluent.getUsageInUsermode());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUUsageBuilder that = (CPUUsageBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

