/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CPUStats;
import io.fabric8.docker.api.model.CPUStatsFluent;
import io.fabric8.docker.api.model.CPUStatsFluentImpl;
import io.fabric8.docker.api.model.EditableCPUStats;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CPUStatsBuilder
extends CPUStatsFluentImpl<CPUStatsBuilder>
implements VisitableBuilder<CPUStats, CPUStatsBuilder> {
    CPUStatsFluent<?> fluent;

    public CPUStatsBuilder() {
        this(new CPUStats());
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent) {
        this(fluent, new CPUStats());
    }

    public CPUStatsBuilder(CPUStatsFluent<?> fluent, CPUStats instance) {
        this.fluent = fluent;
        fluent.withCpuUsage(instance.getCpuUsage());
        fluent.withSystemCpuUsage(instance.getSystemCpuUsage());
        fluent.withThrottlingData(instance.getThrottlingData());
    }

    public CPUStatsBuilder(CPUStats instance) {
        this.fluent = this;
        this.withCpuUsage(instance.getCpuUsage());
        this.withSystemCpuUsage(instance.getSystemCpuUsage());
        this.withThrottlingData(instance.getThrottlingData());
    }

    @Override
    public EditableCPUStats build() {
        EditableCPUStats buildable = new EditableCPUStats(this.fluent.getCpuUsage(), this.fluent.getSystemCpuUsage(), this.fluent.getThrottlingData());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUStatsBuilder that = (CPUStatsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

