/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Address;
import io.fabric8.docker.api.model.AddressFluent;
import io.fabric8.docker.api.model.AddressFluentImpl;
import io.fabric8.docker.api.model.EditableAddress;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AddressBuilder
extends AddressFluentImpl<AddressBuilder>
implements VisitableBuilder<Address, AddressBuilder> {
    AddressFluent<?> fluent;

    public AddressBuilder() {
        this(new Address());
    }

    public AddressBuilder(AddressFluent<?> fluent) {
        this(fluent, new Address());
    }

    public AddressBuilder(AddressFluent<?> fluent, Address instance) {
        this.fluent = fluent;
        fluent.withAddr(instance.getAddr());
        fluent.withPrefixLen(instance.getPrefixLen());
    }

    public AddressBuilder(Address instance) {
        this.fluent = this;
        this.withAddr(instance.getAddr());
        this.withPrefixLen(instance.getPrefixLen());
    }

    @Override
    public EditableAddress build() {
        EditableAddress buildable = new EditableAddress(this.fluent.getAddr(), this.fluent.getPrefixLen());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddressBuilder that = (AddressBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

