package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class VersionFluentImpl<T extends VersionFluent<T>> extends BaseFluent<T> implements VersionFluent<T>{

     String ApiVersion;     String Arch;     String BuildTime;     Boolean Experimental;     String GitCommit;     String GoVersion;     String KernelVersion;     String Os;     String Version;     Map<String, Object> additionalProperties = new HashMap();
public VersionFluentImpl(){
    
}
public VersionFluentImpl( Version instance ){
    this.withApiVersion(instance.getApiVersion()); this.withArch(instance.getArch()); this.withBuildTime(instance.getBuildTime()); this.withExperimental(instance.getExperimental()); this.withGitCommit(instance.getGitCommit()); this.withGoVersion(instance.getGoVersion()); this.withKernelVersion(instance.getKernelVersion()); this.withOs(instance.getOs()); this.withVersion(instance.getVersion()); 
}

    public String getApiVersion(){
    return this.ApiVersion;
    }
    public T withApiVersion( String ApiVersion){
    this.ApiVersion=ApiVersion; return (T) this;
    }
    public String getArch(){
    return this.Arch;
    }
    public T withArch( String Arch){
    this.Arch=Arch; return (T) this;
    }
    public String getBuildTime(){
    return this.BuildTime;
    }
    public T withBuildTime( String BuildTime){
    this.BuildTime=BuildTime; return (T) this;
    }
    public Boolean isExperimental(){
    return this.Experimental;
    }
    public T withExperimental( Boolean Experimental){
    this.Experimental=Experimental; return (T) this;
    }
    public String getGitCommit(){
    return this.GitCommit;
    }
    public T withGitCommit( String GitCommit){
    this.GitCommit=GitCommit; return (T) this;
    }
    public String getGoVersion(){
    return this.GoVersion;
    }
    public T withGoVersion( String GoVersion){
    this.GoVersion=GoVersion; return (T) this;
    }
    public String getKernelVersion(){
    return this.KernelVersion;
    }
    public T withKernelVersion( String KernelVersion){
    this.KernelVersion=KernelVersion; return (T) this;
    }
    public String getOs(){
    return this.Os;
    }
    public T withOs( String Os){
    this.Os=Os; return (T) this;
    }
    public String getVersion(){
    return this.Version;
    }
    public T withVersion( String Version){
    this.Version=Version; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VersionFluentImpl that = (VersionFluentImpl) o;
if (ApiVersion != null ? !ApiVersion.equals(that.ApiVersion) :that.ApiVersion != null) return false;
if (Arch != null ? !Arch.equals(that.Arch) :that.Arch != null) return false;
if (BuildTime != null ? !BuildTime.equals(that.BuildTime) :that.BuildTime != null) return false;
if (Experimental != null ? !Experimental.equals(that.Experimental) :that.Experimental != null) return false;
if (GitCommit != null ? !GitCommit.equals(that.GitCommit) :that.GitCommit != null) return false;
if (GoVersion != null ? !GoVersion.equals(that.GoVersion) :that.GoVersion != null) return false;
if (KernelVersion != null ? !KernelVersion.equals(that.KernelVersion) :that.KernelVersion != null) return false;
if (Os != null ? !Os.equals(that.Os) :that.Os != null) return false;
if (Version != null ? !Version.equals(that.Version) :that.Version != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
