package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.List;
import java.util.AbstractCollection;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface HostConfigFluent<T extends HostConfigFluent<T>> extends Fluent<T>{


    public T addToBinds( String ...items);    public T removeFromBinds( String ...items);    public List<String> getBinds();    public T withBinds( List<String> Binds);    public T withBinds( String ...Binds);    public Integer getBlkioWeight();    public T withBlkioWeight( Integer BlkioWeight);    public T addToCapAdd( String ...items);    public T removeFromCapAdd( String ...items);    public List<String> getCapAdd();    public T withCapAdd( List<String> CapAdd);    public T withCapAdd( String ...CapAdd);    public T addToCapDrop( String ...items);    public T removeFromCapDrop( String ...items);    public List<String> getCapDrop();    public T withCapDrop( List<String> CapDrop);    public T withCapDrop( String ...CapDrop);    public String getCgroupParent();    public T withCgroupParent( String CgroupParent);    public Object getConsoleSize();    public T withConsoleSize( Object ConsoleSize);    public String getContainerIDFile();    public T withContainerIDFile( String ContainerIDFile);    public Long getCpuPeriod();    public T withCpuPeriod( Long CpuPeriod);    public Long getCpuQuota();    public T withCpuQuota( Long CpuQuota);    public Long getCpuShares();    public T withCpuShares( Long CpuShares);    public String getCpusetCpus();    public T withCpusetCpus( String CpusetCpus);    public String getCpusetMems();    public T withCpusetMems( String CpusetMems);    public T addToDevices( DeviceMapping ...items);    public T removeFromDevices( DeviceMapping ...items);    public List<DeviceMapping> getDevices();    public T withDevices( List<DeviceMapping> Devices);    public T withDevices( DeviceMapping ...Devices);    public DevicesNested<T> addNewDevice();    public DevicesNested<T> addNewDeviceLike( DeviceMapping item);    public T addNewDevice( String CgroupPermissions,  String PathInContainer,  String PathOnHost);    public T addToDns( String ...items);    public T removeFromDns( String ...items);    public List<String> getDns();    public T withDns( List<String> Dns);    public T withDns( String ...Dns);    public T addToDnsOptions( String ...items);    public T removeFromDnsOptions( String ...items);    public List<String> getDnsOptions();    public T withDnsOptions( List<String> DnsOptions);    public T withDnsOptions( String ...DnsOptions);    public T addToDnsSearch( String ...items);    public T removeFromDnsSearch( String ...items);    public List<String> getDnsSearch();    public T withDnsSearch( List<String> DnsSearch);    public T withDnsSearch( String ...DnsSearch);    public T addToExtraHosts( String ...items);    public T removeFromExtraHosts( String ...items);    public List<String> getExtraHosts();    public T withExtraHosts( List<String> ExtraHosts);    public T withExtraHosts( String ...ExtraHosts);    public T addToGroupAdd( String ...items);    public T removeFromGroupAdd( String ...items);    public List<String> getGroupAdd();    public T withGroupAdd( List<String> GroupAdd);    public T withGroupAdd( String ...GroupAdd);    public String getIpcMode();    public T withIpcMode( String IpcMode);    public Long getKernelMemory();    public T withKernelMemory( Long KernelMemory);    public T addToLinks( String ...items);    public T removeFromLinks( String ...items);    public List<String> getLinks();    public T withLinks( List<String> Links);    public T withLinks( String ...Links);    public LogConfig getLogConfig();    public T withLogConfig( LogConfig LogConfig);    public LogConfigNested<T> withNewLogConfig();    public LogConfigNested<T> withNewLogConfigLike( LogConfig item);    public LogConfigNested<T> editLogConfig();    public LxcConfig getLxcConf();    public T withLxcConf( LxcConfig LxcConf);    public Long getMemory();    public T withMemory( Long Memory);    public Long getMemoryReservation();    public T withMemoryReservation( Long MemoryReservation);    public Long getMemorySwap();    public T withMemorySwap( Long MemorySwap);    public Long getMemorySwappiness();    public T withMemorySwappiness( Long MemorySwappiness);    public String getNetworkMode();    public T withNetworkMode( String NetworkMode);    public Boolean isOomKillDisable();    public T withOomKillDisable( Boolean OomKillDisable);    public String getPidMode();    public T withPidMode( String PidMode);    public T addToPortBindings( String key,  ArrayList<PortBinding> value);    public T addToPortBindings( Map<String, ArrayList<PortBinding>> map);    public T removeFromPortBindings( String key);    public T removeFromPortBindings( Map<String, ArrayList<PortBinding>> map);    public Map<String, ArrayList<PortBinding>> getPortBindings();    public T withPortBindings( Map<String, ArrayList<PortBinding>> PortBindings);    public Boolean isPrivileged();    public T withPrivileged( Boolean Privileged);    public Boolean isPublishAllPorts();    public T withPublishAllPorts( Boolean PublishAllPorts);    public Boolean isReadonlyRootfs();    public T withReadonlyRootfs( Boolean ReadonlyRootfs);    public RestartPolicy getRestartPolicy();    public T withRestartPolicy( RestartPolicy RestartPolicy);    public RestartPolicyNested<T> withNewRestartPolicy();    public RestartPolicyNested<T> withNewRestartPolicyLike( RestartPolicy item);    public RestartPolicyNested<T> editRestartPolicy();    public T withNewRestartPolicy( Integer MaximumRetryCount,  String Name);    public T addToSecurityOpt( String ...items);    public T removeFromSecurityOpt( String ...items);    public List<String> getSecurityOpt();    public T withSecurityOpt( List<String> SecurityOpt);    public T withSecurityOpt( String ...SecurityOpt);    public String getUTSMode();    public T withUTSMode( String UTSMode);    public T addToUlimits( Ulimit ...items);    public T removeFromUlimits( Ulimit ...items);    public List<Ulimit> getUlimits();    public T withUlimits( List<Ulimit> Ulimits);    public T withUlimits( Ulimit ...Ulimits);    public UlimitsNested<T> addNewUlimit();    public UlimitsNested<T> addNewUlimitLike( Ulimit item);    public T addNewUlimit( Long Hard,  String Name,  Long Soft);    public String getVolumeDriver();    public T withVolumeDriver( String VolumeDriver);    public T addToVolumesFrom( String ...items);    public T removeFromVolumesFrom( String ...items);    public List<String> getVolumesFrom();    public T withVolumesFrom( List<String> VolumesFrom);    public T withVolumesFrom( String ...VolumesFrom);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface DevicesNested<N> extends Nested<N>,DeviceMappingFluent<DevicesNested<N>>{
            public N and();            public N endDevice();        
}

    public interface LogConfigNested<N> extends Nested<N>,LogConfigFluent<LogConfigNested<N>>{
            public N and();            public N endLogConfig();        
}

    public interface RestartPolicyNested<N> extends Nested<N>,RestartPolicyFluent<RestartPolicyNested<N>>{
            public N and();            public N endRestartPolicy();        
}

    public interface UlimitsNested<N> extends Nested<N>,UlimitFluent<UlimitsNested<N>>{
            public N and();            public N endUlimit();        
}


}
