package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class EndpointResourceBuilder extends EndpointResourceFluentImpl<EndpointResourceBuilder> implements VisitableBuilder<EndpointResource,EndpointResourceBuilder>{

     EndpointResourceFluent<?> fluent;
public EndpointResourceBuilder(){
    this(new EndpointResource());
}
public EndpointResourceBuilder( EndpointResourceFluent<?> fluent ){
    this(fluent, new EndpointResource());
}
public EndpointResourceBuilder( EndpointResourceFluent<?> fluent , EndpointResource instance ){
    this.fluent = fluent; fluent.withEndpointID(instance.getEndpointID()); fluent.withIPv4Address(instance.getIPv4Address()); fluent.withIPv6Address(instance.getIPv6Address()); fluent.withMacAddress(instance.getMacAddress()); 
}
public EndpointResourceBuilder( EndpointResource instance ){
    this.fluent = this; this.withEndpointID(instance.getEndpointID()); this.withIPv4Address(instance.getIPv4Address()); this.withIPv6Address(instance.getIPv6Address()); this.withMacAddress(instance.getMacAddress()); 
}

public EditableEndpointResource build(){
    EditableEndpointResource buildable = new EditableEndpointResource(fluent.getEndpointID(),fluent.getIPv4Address(),fluent.getIPv6Address(),fluent.getMacAddress());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EndpointResourceBuilder that = (EndpointResourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
