package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class ContainerPathStatBuilder extends ContainerPathStatFluentImpl<ContainerPathStatBuilder> implements VisitableBuilder<ContainerPathStat,ContainerPathStatBuilder>{

     ContainerPathStatFluent<?> fluent;
public ContainerPathStatBuilder(){
    this(new ContainerPathStat());
}
public ContainerPathStatBuilder( ContainerPathStatFluent<?> fluent ){
    this(fluent, new ContainerPathStat());
}
public ContainerPathStatBuilder( ContainerPathStatFluent<?> fluent , ContainerPathStat instance ){
    this.fluent = fluent; fluent.withLinkTarget(instance.getLinkTarget()); fluent.withMode(instance.getMode()); fluent.withMtime(instance.getMtime()); fluent.withName(instance.getName()); fluent.withSize(instance.getSize()); 
}
public ContainerPathStatBuilder( ContainerPathStat instance ){
    this.fluent = this; this.withLinkTarget(instance.getLinkTarget()); this.withMode(instance.getMode()); this.withMtime(instance.getMtime()); this.withName(instance.getName()); this.withSize(instance.getSize()); 
}

public EditableContainerPathStat build(){
    EditableContainerPathStat buildable = new EditableContainerPathStat(fluent.getLinkTarget(),fluent.getMode(),fluent.getMtime(),fluent.getName(),fluent.getSize());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerPathStatBuilder that = (ContainerPathStatBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
