/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableSearchResult;
import io.fabric8.docker.api.model.SearchResult;
import io.fabric8.docker.api.model.SearchResultFluent;
import io.fabric8.docker.api.model.SearchResultFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SearchResultBuilder
extends SearchResultFluentImpl<SearchResultBuilder>
implements VisitableBuilder<SearchResult, SearchResultBuilder> {
    SearchResultFluent<?> fluent;

    public SearchResultBuilder() {
        this(new SearchResult());
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent) {
        this(fluent, new SearchResult());
    }

    public SearchResultBuilder(SearchResultFluent<?> fluent, SearchResult instance) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withIsAutomated(instance.getIsAutomated());
        fluent.withIsOfficial(instance.getIsOfficial());
        fluent.withIsTrusted(instance.getIsTrusted());
        fluent.withName(instance.getName());
        fluent.withStarCount(instance.getStarCount());
    }

    public SearchResultBuilder(SearchResult instance) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withIsAutomated(instance.getIsAutomated());
        this.withIsOfficial(instance.getIsOfficial());
        this.withIsTrusted(instance.getIsTrusted());
        this.withName(instance.getName());
        this.withStarCount(instance.getStarCount());
    }

    @Override
    public EditableSearchResult build() {
        EditableSearchResult buildable = new EditableSearchResult(this.fluent.getDescription(), this.fluent.isIsAutomated(), this.fluent.isIsOfficial(), this.fluent.isIsTrusted(), this.fluent.getName(), this.fluent.getStarCount());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultBuilder that = (SearchResultBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

