/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetIPNet;
import io.fabric8.docker.api.model.NetIPNet;
import io.fabric8.docker.api.model.NetIPNetFluent;
import io.fabric8.docker.api.model.NetIPNetFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetIPNetBuilder
extends NetIPNetFluentImpl<NetIPNetBuilder>
implements VisitableBuilder<NetIPNet, NetIPNetBuilder> {
    NetIPNetFluent<?> fluent;

    public NetIPNetBuilder() {
        this(new NetIPNet());
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent) {
        this(fluent, new NetIPNet());
    }

    public NetIPNetBuilder(NetIPNetFluent<?> fluent, NetIPNet instance) {
        this.fluent = fluent;
        fluent.withIp(instance.getIp());
        fluent.withMask(instance.getMask());
    }

    public NetIPNetBuilder(NetIPNet instance) {
        this.fluent = this;
        this.withIp(instance.getIp());
        this.withMask(instance.getMask());
    }

    @Override
    public EditableNetIPNet build() {
        EditableNetIPNet buildable = new EditableNetIPNet(this.fluent.getIp(), this.fluent.getMask());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetIPNetBuilder that = (NetIPNetBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

