/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageHistory;
import io.fabric8.docker.api.model.ImageHistory;
import io.fabric8.docker.api.model.ImageHistoryFluent;
import io.fabric8.docker.api.model.ImageHistoryFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageHistoryBuilder
extends ImageHistoryFluentImpl<ImageHistoryBuilder>
implements VisitableBuilder<ImageHistory, ImageHistoryBuilder> {
    ImageHistoryFluent<?> fluent;

    public ImageHistoryBuilder() {
        this(new ImageHistory());
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent) {
        this(fluent, new ImageHistory());
    }

    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent, ImageHistory instance) {
        this.fluent = fluent;
        fluent.withComment(instance.getComment());
        fluent.withCreated(instance.getCreated());
        fluent.withCreatedBy(instance.getCreatedBy());
        fluent.withId(instance.getId());
        fluent.withSize(instance.getSize());
        fluent.withTags(instance.getTags());
    }

    public ImageHistoryBuilder(ImageHistory instance) {
        this.fluent = this;
        this.withComment(instance.getComment());
        this.withCreated(instance.getCreated());
        this.withCreatedBy(instance.getCreatedBy());
        this.withId(instance.getId());
        this.withSize(instance.getSize());
        this.withTags(instance.getTags());
    }

    @Override
    public EditableImageHistory build() {
        EditableImageHistory buildable = new EditableImageHistory(this.fluent.getComment(), this.fluent.getCreated(), this.fluent.getCreatedBy(), this.fluent.getId(), this.fluent.getSize(), this.fluent.getTags());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageHistoryBuilder that = (ImageHistoryBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

