/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageDelete;
import io.fabric8.docker.api.model.ImageDelete;
import io.fabric8.docker.api.model.ImageDeleteFluent;
import io.fabric8.docker.api.model.ImageDeleteFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageDeleteBuilder
extends ImageDeleteFluentImpl<ImageDeleteBuilder>
implements VisitableBuilder<ImageDelete, ImageDeleteBuilder> {
    ImageDeleteFluent<?> fluent;

    public ImageDeleteBuilder() {
        this(new ImageDelete());
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent) {
        this(fluent, new ImageDelete());
    }

    public ImageDeleteBuilder(ImageDeleteFluent<?> fluent, ImageDelete instance) {
        this.fluent = fluent;
        fluent.withDeleted(instance.getDeleted());
        fluent.withUntagged(instance.getUntagged());
    }

    public ImageDeleteBuilder(ImageDelete instance) {
        this.fluent = this;
        this.withDeleted(instance.getDeleted());
        this.withUntagged(instance.getUntagged());
    }

    @Override
    public EditableImageDelete build() {
        EditableImageDelete buildable = new EditableImageDelete(this.fluent.getDeleted(), this.fluent.getUntagged());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageDeleteBuilder that = (ImageDeleteBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

