/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.DeviceMapping;
import io.fabric8.docker.api.model.DeviceMappingFluent;
import io.fabric8.docker.api.model.DeviceMappingFluentImpl;
import io.fabric8.docker.api.model.EditableDeviceMapping;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeviceMappingBuilder
extends DeviceMappingFluentImpl<DeviceMappingBuilder>
implements VisitableBuilder<DeviceMapping, DeviceMappingBuilder> {
    DeviceMappingFluent<?> fluent;

    public DeviceMappingBuilder() {
        this(new DeviceMapping());
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent) {
        this(fluent, new DeviceMapping());
    }

    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent, DeviceMapping instance) {
        this.fluent = fluent;
        fluent.withCgroupPermissions(instance.getCgroupPermissions());
        fluent.withPathInContainer(instance.getPathInContainer());
        fluent.withPathOnHost(instance.getPathOnHost());
    }

    public DeviceMappingBuilder(DeviceMapping instance) {
        this.fluent = this;
        this.withCgroupPermissions(instance.getCgroupPermissions());
        this.withPathInContainer(instance.getPathInContainer());
        this.withPathOnHost(instance.getPathOnHost());
    }

    @Override
    public EditableDeviceMapping build() {
        EditableDeviceMapping buildable = new EditableDeviceMapping(this.fluent.getCgroupPermissions(), this.fluent.getPathInContainer(), this.fluent.getPathOnHost());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceMappingBuilder that = (DeviceMappingBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

