package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Fluent;

public interface ContainerStateFluent<T extends ContainerStateFluent<T>> extends Fluent<T>{


    public Boolean isDead();    public T withDead( Boolean Dead);    public String getError();    public T withError( String Error);    public Integer getExitCode();    public T withExitCode( Integer ExitCode);    public String getFinishedAt();    public T withFinishedAt( String FinishedAt);    public Boolean isOOMKilled();    public T withOOMKilled( Boolean OOMKilled);    public Boolean isPaused();    public T withPaused( Boolean Paused);    public Integer getPid();    public T withPid( Integer Pid);    public Boolean isRestarting();    public T withRestarting( Boolean Restarting);    public Boolean isRunning();    public T withRunning( Boolean Running);    public String getStartedAt();    public T withStartedAt( String StartedAt);    public String getStatus();    public T withStatus( String Status);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);

}
