package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface ContainerJSONBaseFluent<T extends ContainerJSONBaseFluent<T>> extends Fluent<T>{


    public String getAppArmorProfile();    public T withAppArmorProfile( String AppArmorProfile);    public T addToArgs( String ...items);    public T removeFromArgs( String ...items);    public List<String> getArgs();    public T withArgs( List<String> Args);    public T withArgs( String ...Args);    public String getCreated();    public T withCreated( String Created);    public String getDriver();    public T withDriver( String Driver);    public String getExecDriver();    public T withExecDriver( String ExecDriver);    public T addToExecIDs( String ...items);    public T removeFromExecIDs( String ...items);    public List<String> getExecIDs();    public T withExecIDs( List<String> ExecIDs);    public T withExecIDs( String ...ExecIDs);    public GraphDriverData getGraphDriver();    public T withGraphDriver( GraphDriverData GraphDriver);    public GraphDriverNested<T> withNewGraphDriver();    public GraphDriverNested<T> withNewGraphDriverLike( GraphDriverData item);    public GraphDriverNested<T> editGraphDriver();    public HostConfig getHostConfig();    public T withHostConfig( HostConfig HostConfig);    public HostConfigNested<T> withNewHostConfig();    public HostConfigNested<T> withNewHostConfigLike( HostConfig item);    public HostConfigNested<T> editHostConfig();    public String getHostnamePath();    public T withHostnamePath( String HostnamePath);    public String getHostsPath();    public T withHostsPath( String HostsPath);    public String getId();    public T withId( String Id);    public String getImage();    public T withImage( String Image);    public String getLogPath();    public T withLogPath( String LogPath);    public String getMountLabel();    public T withMountLabel( String MountLabel);    public String getName();    public T withName( String Name);    public String getPath();    public T withPath( String Path);    public String getProcessLabel();    public T withProcessLabel( String ProcessLabel);    public String getResolvConfPath();    public T withResolvConfPath( String ResolvConfPath);    public Integer getRestartCount();    public T withRestartCount( Integer RestartCount);    public Long getSizeRootFs();    public T withSizeRootFs( Long SizeRootFs);    public Long getSizeRw();    public T withSizeRw( Long SizeRw);    public ContainerState getState();    public T withState( ContainerState State);    public StateNested<T> withNewState();    public StateNested<T> withNewStateLike( ContainerState item);    public StateNested<T> editState();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface GraphDriverNested<N> extends Nested<N>,GraphDriverDataFluent<GraphDriverNested<N>>{
            public N endGraphDriver();            public N and();        
}

    public interface HostConfigNested<N> extends Nested<N>,HostConfigFluent<HostConfigNested<N>>{
            public N and();            public N endHostConfig();        
}

    public interface StateNested<N> extends Nested<N>,ContainerStateFluent<StateNested<N>>{
            public N and();            public N endState();        
}


}
