package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface ContainerFluent<T extends ContainerFluent<T>> extends Fluent<T>{


    public String getId();    public T withId( String id);    public T addToNames( String ...items);    public T removeFromNames( String ...items);    public List<String> getNames();    public T withNames( List<String> names);    public T withNames( String ...names);    public String getImage();    public T withImage( String image);    public String getImageId();    public T withImageId( String imageId);    public String getCommand();    public T withCommand( String command);    public Long getCreated();    public T withCreated( Long created);    public T addToPorts( Port ...items);    public T removeFromPorts( Port ...items);    public List<Port> getPorts();    public T withPorts( List<Port> ports);    public T withPorts( Port ...ports);    public PortsNested<T> addNewPort();    public PortsNested<T> addNewPortLike( Port item);    public T addNewPort( String IP,  Integer PrivatePort,  Integer PublicPort,  String Type);    public Long getSizeRw();    public T withSizeRw( Long sizeRw);    public Long getSizeRootFs();    public T withSizeRootFs( Long sizeRootFs);    public T addToLabels( String key,  String value);    public T addToLabels( Map<String, String> map);    public T removeFromLabels( String key);    public T removeFromLabels( Map<String, String> map);    public Map<String, String> getLabels();    public T withLabels( Map<String, String> labels);    public String getStatus();    public T withStatus( String status);    public ContainerHostConfig getHostConfig();    public T withHostConfig( ContainerHostConfig hostConfig);    public HostConfigNested<T> withNewHostConfig();    public HostConfigNested<T> withNewHostConfigLike( ContainerHostConfig item);    public HostConfigNested<T> editHostConfig();    public T withNewHostConfig( String networkMode);    public NetworkSettings getSummaryNetworkSettings();    public T withSummaryNetworkSettings( NetworkSettings summaryNetworkSettings);    public SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettings();    public SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettingsLike( NetworkSettings item);    public SummaryNetworkSettingsNested<T> editSummaryNetworkSettings();
    public interface PortsNested<N> extends Nested<N>,PortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}

    public interface HostConfigNested<N> extends Nested<N>,ContainerHostConfigFluent<HostConfigNested<N>>{
            public N and();            public N endHostConfig();        
}

    public interface SummaryNetworkSettingsNested<N> extends Nested<N>,NetworkSettingsFluent<SummaryNetworkSettingsNested<N>>{
            public N and();            public N endSummaryNetworkSettings();        
}


}
