package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class CPUStatsFluentImpl<T extends CPUStatsFluent<T>> extends BaseFluent<T> implements CPUStatsFluent<T>{

     VisitableBuilder<CPUUsage, ?> cpuUsage;     Long systemCpuUsage;     VisitableBuilder<ThrottlingData, ?> throttlingData;     Map<String, Object> additionalProperties = new HashMap();
public CPUStatsFluentImpl(){
    
}
public CPUStatsFluentImpl( CPUStats instance ){
    this.withCpuUsage(instance.getCpuUsage()); this.withSystemCpuUsage(instance.getSystemCpuUsage()); this.withThrottlingData(instance.getThrottlingData()); 
}

    public CPUUsage getCpuUsage(){
    return this.cpuUsage!=null?this.cpuUsage.build():null;
    }
    public T withCpuUsage( CPUUsage cpuUsage){
    if (cpuUsage!=null){ this.cpuUsage= new CPUUsageBuilder(cpuUsage); _visitables.add(this.cpuUsage);} return (T) this;
    }
    public CpuUsageNested<T> withNewCpuUsage(){
    return new CpuUsageNestedImpl<T>();
    }
    public CpuUsageNested<T> withNewCpuUsageLike( CPUUsage item){
    return new CpuUsageNestedImpl<T>(item);
    }
    public CpuUsageNested<T> editCpuUsage(){
    return withNewCpuUsageLike(getCpuUsage());
    }
    public Long getSystemCpuUsage(){
    return this.systemCpuUsage;
    }
    public T withSystemCpuUsage( Long systemCpuUsage){
    this.systemCpuUsage=systemCpuUsage; return (T) this;
    }
    public ThrottlingData getThrottlingData(){
    return this.throttlingData!=null?this.throttlingData.build():null;
    }
    public T withThrottlingData( ThrottlingData throttlingData){
    if (throttlingData!=null){ this.throttlingData= new ThrottlingDataBuilder(throttlingData); _visitables.add(this.throttlingData);} return (T) this;
    }
    public ThrottlingDataNested<T> withNewThrottlingData(){
    return new ThrottlingDataNestedImpl<T>();
    }
    public ThrottlingDataNested<T> withNewThrottlingDataLike( ThrottlingData item){
    return new ThrottlingDataNestedImpl<T>(item);
    }
    public ThrottlingDataNested<T> editThrottlingData(){
    return withNewThrottlingDataLike(getThrottlingData());
    }
    public T withNewThrottlingData( Long periods,  Long throttledPeriods,  Long throttledTime){
    return withThrottlingData(new ThrottlingData(periods, throttledPeriods, throttledTime));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CPUStatsFluentImpl that = (CPUStatsFluentImpl) o;
if (cpuUsage != null ? !cpuUsage.equals(that.cpuUsage) :that.cpuUsage != null) return false;
if (systemCpuUsage != null ? !systemCpuUsage.equals(that.systemCpuUsage) :that.systemCpuUsage != null) return false;
if (throttlingData != null ? !throttlingData.equals(that.throttlingData) :that.throttlingData != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CpuUsageNestedImpl<N> extends CPUUsageFluentImpl<CpuUsageNested<N>> implements CpuUsageNested<N>{

        private final CPUUsageBuilder builder;
    
             CpuUsageNestedImpl (){
        this.builder = new CPUUsageBuilder(this);
        }
             CpuUsageNestedImpl ( CPUUsage item){
        this.builder = new CPUUsageBuilder(this, item);
        }
    
            public N endCpuUsage(){
            return and();
        }
            public N and(){
            return (N) CPUStatsFluentImpl.this.withCpuUsage(builder.build());
        }
    
}
    public class ThrottlingDataNestedImpl<N> extends ThrottlingDataFluentImpl<ThrottlingDataNested<N>> implements ThrottlingDataNested<N>{

        private final ThrottlingDataBuilder builder;
    
             ThrottlingDataNestedImpl (){
        this.builder = new ThrottlingDataBuilder(this);
        }
             ThrottlingDataNestedImpl ( ThrottlingData item){
        this.builder = new ThrottlingDataBuilder(this, item);
        }
    
            public N and(){
            return (N) CPUStatsFluentImpl.this.withThrottlingData(builder.build());
        }
            public N endThrottlingData(){
            return and();
        }
    
}


}
