package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class BlkioStatEntryFluentImpl<T extends BlkioStatEntryFluent<T>> extends BaseFluent<T> implements BlkioStatEntryFluent<T>{

     Long major;     Long minor;     String op;     Long value;     Map<String, Object> additionalProperties = new HashMap();
public BlkioStatEntryFluentImpl(){
    
}
public BlkioStatEntryFluentImpl( BlkioStatEntry instance ){
    this.withMajor(instance.getMajor()); this.withMinor(instance.getMinor()); this.withOp(instance.getOp()); this.withValue(instance.getValue()); 
}

    public Long getMajor(){
    return this.major;
    }
    public T withMajor( Long major){
    this.major=major; return (T) this;
    }
    public Long getMinor(){
    return this.minor;
    }
    public T withMinor( Long minor){
    this.minor=minor; return (T) this;
    }
    public String getOp(){
    return this.op;
    }
    public T withOp( String op){
    this.op=op; return (T) this;
    }
    public Long getValue(){
    return this.value;
    }
    public T withValue( Long value){
    this.value=value; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BlkioStatEntryFluentImpl that = (BlkioStatEntryFluentImpl) o;
if (major != null ? !major.equals(that.major) :that.major != null) return false;
if (minor != null ? !minor.equals(that.minor) :that.minor != null) return false;
if (op != null ? !op.equals(that.op) :that.op != null) return false;
if (value != null ? !value.equals(that.value) :that.value != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
