/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkResource;
import io.fabric8.docker.api.model.NetworkResource;
import io.fabric8.docker.api.model.NetworkResourceFluent;
import io.fabric8.docker.api.model.NetworkResourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkResourceBuilder
extends NetworkResourceFluentImpl<NetworkResourceBuilder>
implements VisitableBuilder<NetworkResource, NetworkResourceBuilder> {
    NetworkResourceFluent<?> fluent;

    public NetworkResourceBuilder() {
        this(new NetworkResource());
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent) {
        this(fluent, new NetworkResource());
    }

    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent, NetworkResource instance) {
        this.fluent = fluent;
        fluent.withContainers(instance.getContainers());
        fluent.withDriver(instance.getDriver());
        fluent.withIPAM(instance.getIPAM());
        fluent.withId(instance.getId());
        fluent.withName(instance.getName());
        fluent.withOptions(instance.getOptions());
        fluent.withScope(instance.getScope());
    }

    public NetworkResourceBuilder(NetworkResource instance) {
        this.fluent = this;
        this.withContainers(instance.getContainers());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withId(instance.getId());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
        this.withScope(instance.getScope());
    }

    @Override
    public EditableNetworkResource build() {
        EditableNetworkResource buildable = new EditableNetworkResource(this.fluent.getContainers(), this.fluent.getDriver(), this.fluent.getIPAM(), this.fluent.getId(), this.fluent.getName(), this.fluent.getOptions(), this.fluent.getScope());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkResourceBuilder that = (NetworkResourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

