/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkConnect;
import io.fabric8.docker.api.model.NetworkConnect;
import io.fabric8.docker.api.model.NetworkConnectFluent;
import io.fabric8.docker.api.model.NetworkConnectFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkConnectBuilder
extends NetworkConnectFluentImpl<NetworkConnectBuilder>
implements VisitableBuilder<NetworkConnect, NetworkConnectBuilder> {
    NetworkConnectFluent<?> fluent;

    public NetworkConnectBuilder() {
        this(new NetworkConnect());
    }

    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent) {
        this(fluent, new NetworkConnect());
    }

    public NetworkConnectBuilder(NetworkConnectFluent<?> fluent, NetworkConnect instance) {
        this.fluent = fluent;
        fluent.withContainer(instance.getContainer());
    }

    public NetworkConnectBuilder(NetworkConnect instance) {
        this.fluent = this;
        this.withContainer(instance.getContainer());
    }

    @Override
    public EditableNetworkConnect build() {
        EditableNetworkConnect buildable = new EditableNetworkConnect(this.fluent.getContainer());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkConnectBuilder that = (NetworkConnectBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

