/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableMountPoint;
import io.fabric8.docker.api.model.MountPoint;
import io.fabric8.docker.api.model.MountPointFluent;
import io.fabric8.docker.api.model.MountPointFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MountPointBuilder
extends MountPointFluentImpl<MountPointBuilder>
implements VisitableBuilder<MountPoint, MountPointBuilder> {
    MountPointFluent<?> fluent;

    public MountPointBuilder() {
        this(new MountPoint());
    }

    public MountPointBuilder(MountPointFluent<?> fluent) {
        this(fluent, new MountPoint());
    }

    public MountPointBuilder(MountPointFluent<?> fluent, MountPoint instance) {
        this.fluent = fluent;
        fluent.withDestination(instance.getDestination());
        fluent.withDriver(instance.getDriver());
        fluent.withMode(instance.getMode());
        fluent.withName(instance.getName());
        fluent.withRW(instance.getRW());
        fluent.withSource(instance.getSource());
    }

    public MountPointBuilder(MountPoint instance) {
        this.fluent = this;
        this.withDestination(instance.getDestination());
        this.withDriver(instance.getDriver());
        this.withMode(instance.getMode());
        this.withName(instance.getName());
        this.withRW(instance.getRW());
        this.withSource(instance.getSource());
    }

    @Override
    public EditableMountPoint build() {
        EditableMountPoint buildable = new EditableMountPoint(this.fluent.getDestination(), this.fluent.getDriver(), this.fluent.getMode(), this.fluent.getName(), this.fluent.isRW(), this.fluent.getSource());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MountPointBuilder that = (MountPointBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

