/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableUlimit;
import io.fabric8.docker.api.model.Ulimit;
import io.fabric8.docker.api.model.UlimitFluent;
import io.fabric8.docker.api.model.UlimitFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class UlimitBuilder
extends UlimitFluentImpl<UlimitBuilder>
implements VisitableBuilder<Ulimit, UlimitBuilder> {
    UlimitFluent<?> fluent;

    public UlimitBuilder() {
        this(new Ulimit());
    }

    public UlimitBuilder(UlimitFluent<?> fluent) {
        this(fluent, new Ulimit());
    }

    public UlimitBuilder(UlimitFluent<?> fluent, Ulimit instance) {
        this.fluent = fluent;
        fluent.withHard(instance.getHard());
        fluent.withName(instance.getName());
        fluent.withSoft(instance.getSoft());
    }

    public UlimitBuilder(Ulimit instance) {
        this.fluent = this;
        this.withHard(instance.getHard());
        this.withName(instance.getName());
        this.withSoft(instance.getSoft());
    }

    @Override
    public EditableUlimit build() {
        EditableUlimit buildable = new EditableUlimit(this.fluent.getHard(), this.fluent.getName(), this.fluent.getSoft());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UlimitBuilder that = (UlimitBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

