/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Config;
import io.fabric8.docker.api.model.ConfigBuilder;
import io.fabric8.docker.api.model.ConfigFluentImpl;
import io.fabric8.docker.api.model.GraphDriverData;
import io.fabric8.docker.api.model.GraphDriverDataBuilder;
import io.fabric8.docker.api.model.GraphDriverDataFluentImpl;
import io.fabric8.docker.api.model.ImageInspect;
import io.fabric8.docker.api.model.ImageInspectFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageInspectFluentImpl<T extends ImageInspectFluent<T>>
extends BaseFluent<T>
implements ImageInspectFluent<T> {
    String Architecture;
    String Author;
    String Comment;
    VisitableBuilder<Config, ?> Config;
    String Container;
    VisitableBuilder<Config, ?> ContainerConfig;
    String Created;
    String DockerVersion;
    VisitableBuilder<GraphDriverData, ?> GraphDriver;
    String Id;
    String Os;
    String Parent;
    List<String> RepoDigests = new ArrayList<String>();
    List<String> RepoTags = new ArrayList<String>();
    Long Size;
    Long VirtualSize;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageInspectFluentImpl() {
    }

    public ImageInspectFluentImpl(ImageInspect instance) {
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withGraphDriver(instance.getGraphDriver());
        this.withId(instance.getId());
        this.withOs(instance.getOs());
        this.withParent(instance.getParent());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
    }

    @Override
    public String getArchitecture() {
        return this.Architecture;
    }

    @Override
    public T withArchitecture(String Architecture) {
        this.Architecture = Architecture;
        return (T)this;
    }

    @Override
    public String getAuthor() {
        return this.Author;
    }

    @Override
    public T withAuthor(String Author) {
        this.Author = Author;
        return (T)this;
    }

    @Override
    public String getComment() {
        return this.Comment;
    }

    @Override
    public T withComment(String Comment) {
        this.Comment = Comment;
        return (T)this;
    }

    @Override
    public Config getConfig() {
        return this.Config != null ? (Config)this.Config.build() : null;
    }

    @Override
    public T withConfig(Config Config2) {
        if (Config2 != null) {
            this.Config = new ConfigBuilder(Config2);
            this._visitables.add(this.Config);
        }
        return (T)this;
    }

    @Override
    public ImageInspectFluent.ConfigNested<T> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public ImageInspectFluent.ConfigNested<T> withNewConfigLike(Config item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.ConfigNested<T> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public String getContainer() {
        return this.Container;
    }

    @Override
    public T withContainer(String Container2) {
        this.Container = Container2;
        return (T)this;
    }

    @Override
    public Config getContainerConfig() {
        return this.ContainerConfig != null ? (Config)this.ContainerConfig.build() : null;
    }

    @Override
    public T withContainerConfig(Config ContainerConfig) {
        if (ContainerConfig != null) {
            this.ContainerConfig = new ConfigBuilder(ContainerConfig);
            this._visitables.add(this.ContainerConfig);
        }
        return (T)this;
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<T> withNewContainerConfig() {
        return new ContainerConfigNestedImpl();
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<T> withNewContainerConfigLike(Config item) {
        return new ContainerConfigNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.ContainerConfigNested<T> editContainerConfig() {
        return this.withNewContainerConfigLike(this.getContainerConfig());
    }

    @Override
    public String getCreated() {
        return this.Created;
    }

    @Override
    public T withCreated(String Created) {
        this.Created = Created;
        return (T)this;
    }

    @Override
    public String getDockerVersion() {
        return this.DockerVersion;
    }

    @Override
    public T withDockerVersion(String DockerVersion) {
        this.DockerVersion = DockerVersion;
        return (T)this;
    }

    @Override
    public GraphDriverData getGraphDriver() {
        return this.GraphDriver != null ? (GraphDriverData)this.GraphDriver.build() : null;
    }

    @Override
    public T withGraphDriver(GraphDriverData GraphDriver) {
        if (GraphDriver != null) {
            this.GraphDriver = new GraphDriverDataBuilder(GraphDriver);
            this._visitables.add(this.GraphDriver);
        }
        return (T)this;
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<T> withNewGraphDriver() {
        return new GraphDriverNestedImpl();
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<T> withNewGraphDriverLike(GraphDriverData item) {
        return new GraphDriverNestedImpl(item);
    }

    @Override
    public ImageInspectFluent.GraphDriverNested<T> editGraphDriver() {
        return this.withNewGraphDriverLike(this.getGraphDriver());
    }

    @Override
    public String getId() {
        return this.Id;
    }

    @Override
    public T withId(String Id) {
        this.Id = Id;
        return (T)this;
    }

    @Override
    public String getOs() {
        return this.Os;
    }

    @Override
    public T withOs(String Os) {
        this.Os = Os;
        return (T)this;
    }

    @Override
    public String getParent() {
        return this.Parent;
    }

    @Override
    public T withParent(String Parent) {
        this.Parent = Parent;
        return (T)this;
    }

    @Override
    public T addToRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromRepoDigests(String ... items) {
        for (String item : items) {
            this.RepoDigests.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getRepoDigests() {
        return this.RepoDigests;
    }

    @Override
    public T withRepoDigests(List<String> RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRepoDigests(String ... RepoDigests) {
        this.RepoDigests.clear();
        if (RepoDigests != null) {
            for (String item : RepoDigests) {
                this.addToRepoDigests(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromRepoTags(String ... items) {
        for (String item : items) {
            this.RepoTags.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getRepoTags() {
        return this.RepoTags;
    }

    @Override
    public T withRepoTags(List<String> RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRepoTags(String ... RepoTags) {
        this.RepoTags.clear();
        if (RepoTags != null) {
            for (String item : RepoTags) {
                this.addToRepoTags(item);
            }
        }
        return (T)this;
    }

    @Override
    public Long getSize() {
        return this.Size;
    }

    @Override
    public T withSize(Long Size) {
        this.Size = Size;
        return (T)this;
    }

    @Override
    public Long getVirtualSize() {
        return this.VirtualSize;
    }

    @Override
    public T withVirtualSize(Long VirtualSize) {
        this.VirtualSize = VirtualSize;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInspectFluentImpl that = (ImageInspectFluentImpl)o;
        if (this.Architecture != null ? !this.Architecture.equals(that.Architecture) : that.Architecture != null) {
            return false;
        }
        if (this.Author != null ? !this.Author.equals(that.Author) : that.Author != null) {
            return false;
        }
        if (this.Comment != null ? !this.Comment.equals(that.Comment) : that.Comment != null) {
            return false;
        }
        if (this.Config != null ? !this.Config.equals(that.Config) : that.Config != null) {
            return false;
        }
        if (this.Container != null ? !this.Container.equals(that.Container) : that.Container != null) {
            return false;
        }
        if (this.ContainerConfig != null ? !this.ContainerConfig.equals(that.ContainerConfig) : that.ContainerConfig != null) {
            return false;
        }
        if (this.Created != null ? !this.Created.equals(that.Created) : that.Created != null) {
            return false;
        }
        if (this.DockerVersion != null ? !this.DockerVersion.equals(that.DockerVersion) : that.DockerVersion != null) {
            return false;
        }
        if (this.GraphDriver != null ? !this.GraphDriver.equals(that.GraphDriver) : that.GraphDriver != null) {
            return false;
        }
        if (this.Id != null ? !this.Id.equals(that.Id) : that.Id != null) {
            return false;
        }
        if (this.Os != null ? !this.Os.equals(that.Os) : that.Os != null) {
            return false;
        }
        if (this.Parent != null ? !this.Parent.equals(that.Parent) : that.Parent != null) {
            return false;
        }
        if (this.RepoDigests != null ? !this.RepoDigests.equals(that.RepoDigests) : that.RepoDigests != null) {
            return false;
        }
        if (this.RepoTags != null ? !this.RepoTags.equals(that.RepoTags) : that.RepoTags != null) {
            return false;
        }
        if (this.Size != null ? !this.Size.equals(that.Size) : that.Size != null) {
            return false;
        }
        if (this.VirtualSize != null ? !this.VirtualSize.equals(that.VirtualSize) : that.VirtualSize != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class GraphDriverNestedImpl<N>
    extends GraphDriverDataFluentImpl<ImageInspectFluent.GraphDriverNested<N>>
    implements ImageInspectFluent.GraphDriverNested<N> {
        private final GraphDriverDataBuilder builder;

        GraphDriverNestedImpl() {
            this.builder = new GraphDriverDataBuilder(this);
        }

        GraphDriverNestedImpl(GraphDriverData item) {
            this.builder = new GraphDriverDataBuilder(this, item);
        }

        @Override
        public N endGraphDriver() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withGraphDriver(this.builder.build());
        }
    }

    public class ContainerConfigNestedImpl<N>
    extends ConfigFluentImpl<ImageInspectFluent.ContainerConfigNested<N>>
    implements ImageInspectFluent.ContainerConfigNested<N> {
        private final ConfigBuilder builder;

        ContainerConfigNestedImpl() {
            this.builder = new ConfigBuilder(this);
        }

        ContainerConfigNestedImpl(Config item) {
            this.builder = new ConfigBuilder(this, item);
        }

        @Override
        public N endContainerConfig() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withContainerConfig(this.builder.build());
        }
    }

    public class ConfigNestedImpl<N>
    extends ConfigFluentImpl<ImageInspectFluent.ConfigNested<N>>
    implements ImageInspectFluent.ConfigNested<N> {
        private final ConfigBuilder builder;

        ConfigNestedImpl() {
            this.builder = new ConfigBuilder(this);
        }

        ConfigNestedImpl(Config item) {
            this.builder = new ConfigBuilder(this, item);
        }

        @Override
        public N endConfig() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageInspectFluentImpl.this.withConfig(this.builder.build());
        }
    }
}

