/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CopyConfig;
import io.fabric8.docker.api.model.CopyConfigFluent;
import io.fabric8.docker.api.model.CopyConfigFluentImpl;
import io.fabric8.docker.api.model.EditableCopyConfig;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CopyConfigBuilder
extends CopyConfigFluentImpl<CopyConfigBuilder>
implements VisitableBuilder<CopyConfig, CopyConfigBuilder> {
    CopyConfigFluent<?> fluent;

    public CopyConfigBuilder() {
        this(new CopyConfig());
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent) {
        this(fluent, new CopyConfig());
    }

    public CopyConfigBuilder(CopyConfigFluent<?> fluent, CopyConfig instance) {
        this.fluent = fluent;
        fluent.withResource(instance.getResource());
    }

    public CopyConfigBuilder(CopyConfig instance) {
        this.fluent = this;
        this.withResource(instance.getResource());
    }

    @Override
    public EditableCopyConfig build() {
        EditableCopyConfig buildable = new EditableCopyConfig(this.fluent.getResource());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyConfigBuilder that = (CopyConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

