/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerWaitResponse;
import io.fabric8.docker.api.model.ContainerWaitResponseFluent;
import io.fabric8.docker.api.model.ContainerWaitResponseFluentImpl;
import io.fabric8.docker.api.model.EditableContainerWaitResponse;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerWaitResponseBuilder
extends ContainerWaitResponseFluentImpl<ContainerWaitResponseBuilder>
implements VisitableBuilder<ContainerWaitResponse, ContainerWaitResponseBuilder> {
    ContainerWaitResponseFluent<?> fluent;

    public ContainerWaitResponseBuilder() {
        this(new ContainerWaitResponse());
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent) {
        this(fluent, new ContainerWaitResponse());
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent, ContainerWaitResponse instance) {
        this.fluent = fluent;
        fluent.withStatusCode(instance.getStatusCode());
    }

    public ContainerWaitResponseBuilder(ContainerWaitResponse instance) {
        this.fluent = this;
        this.withStatusCode(instance.getStatusCode());
    }

    @Override
    public EditableContainerWaitResponse build() {
        EditableContainerWaitResponse buildable = new EditableContainerWaitResponse(this.fluent.getStatusCode());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerWaitResponseBuilder that = (ContainerWaitResponseBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

