/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVolume;
import io.fabric8.docker.api.model.Volume;
import io.fabric8.docker.api.model.VolumeFluent;
import io.fabric8.docker.api.model.VolumeFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeBuilder
extends VolumeFluentImpl<VolumeBuilder>
implements VisitableBuilder<Volume, VolumeBuilder> {
    VolumeFluent<?> fluent;

    public VolumeBuilder() {
        this(new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this.fluent = fluent;
        fluent.withDriver(instance.getDriver());
        fluent.withMountpoint(instance.getMountpoint());
        fluent.withName(instance.getName());
    }

    public VolumeBuilder(Volume instance) {
        this.fluent = this;
        this.withDriver(instance.getDriver());
        this.withMountpoint(instance.getMountpoint());
        this.withName(instance.getName());
    }

    @Override
    public EditableVolume build() {
        EditableVolume buildable = new EditableVolume(this.fluent.getDriver(), this.fluent.getMountpoint(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeBuilder that = (VolumeBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

