/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"IP", "Mask"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class NetIPNet {
    private static final String IP = "ip";
    private static final String MASK = "mask";
    private static final Pattern NETIP_PATTERN = Pattern.compile("(?<ip>[^ /]+)/(?<mask>\\d+)");
    @JsonProperty(value="IP")
    private String ip;
    @JsonProperty(value="Mask")
    private String mask;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public NetIPNet() {
    }

    public NetIPNet(String ip, String mask) {
        this.ip = ip;
        this.mask = mask;
    }

    public NetIPNet(String s) {
        if (s == null) {
            throw new IllegalArgumentException(s);
        }
        Matcher m = NETIP_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(s);
        }
        this.ip = m.group(IP);
        this.mask = m.group(MASK);
    }

    @JsonProperty(value="IP")
    public String getIp() {
        return this.ip;
    }

    @JsonProperty(value="IP")
    public void setIp(String ip) {
        this.ip = ip;
    }

    @JsonProperty(value="Mask")
    public String getMask() {
        return this.mask;
    }

    @JsonProperty(value="Mask")
    public void setMask(String mask) {
        this.mask = mask;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "NetIPNet(ip=" + this.getIp() + ", mask=" + this.getMask() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetIPNet)) {
            return false;
        }
        NetIPNet other = (NetIPNet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$mask = this.getMask();
        String other$mask = other.getMask();
        if (this$mask == null ? other$mask != null : !this$mask.equals(other$mask)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetIPNet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 0 : $ip.hashCode());
        String $mask = this.getMask();
        result = result * 59 + ($mask == null ? 0 : $mask.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

