/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImageInspect;
import io.fabric8.docker.api.model.ImageInspect;
import io.fabric8.docker.api.model.ImageInspectFluent;
import io.fabric8.docker.api.model.ImageInspectFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageInspectBuilder
extends ImageInspectFluentImpl<ImageInspectBuilder>
implements VisitableBuilder<ImageInspect, ImageInspectBuilder> {
    ImageInspectFluent<?> fluent;

    public ImageInspectBuilder() {
        this(new ImageInspect());
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent) {
        this(fluent, new ImageInspect());
    }

    public ImageInspectBuilder(ImageInspectFluent<?> fluent, ImageInspect instance) {
        this.fluent = fluent;
        fluent.withArchitecture(instance.getArchitecture());
        fluent.withAuthor(instance.getAuthor());
        fluent.withComment(instance.getComment());
        fluent.withConfig(instance.getConfig());
        fluent.withContainer(instance.getContainer());
        fluent.withContainerConfig(instance.getContainerConfig());
        fluent.withCreated(instance.getCreated());
        fluent.withDockerVersion(instance.getDockerVersion());
        fluent.withGraphDriver(instance.getGraphDriver());
        fluent.withId(instance.getId());
        fluent.withOs(instance.getOs());
        fluent.withParent(instance.getParent());
        fluent.withRepoDigests(instance.getRepoDigests());
        fluent.withRepoTags(instance.getRepoTags());
        fluent.withSize(instance.getSize());
        fluent.withVirtualSize(instance.getVirtualSize());
    }

    public ImageInspectBuilder(ImageInspect instance) {
        this.fluent = this;
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withGraphDriver(instance.getGraphDriver());
        this.withId(instance.getId());
        this.withOs(instance.getOs());
        this.withParent(instance.getParent());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
    }

    @Override
    public EditableImageInspect build() {
        EditableImageInspect buildable = new EditableImageInspect(this.fluent.getArchitecture(), this.fluent.getAuthor(), this.fluent.getComment(), this.fluent.getConfig(), this.fluent.getContainer(), this.fluent.getContainerConfig(), this.fluent.getCreated(), this.fluent.getDockerVersion(), this.fluent.getGraphDriver(), this.fluent.getId(), this.fluent.getOs(), this.fluent.getParent(), this.fluent.getRepoDigests(), this.fluent.getRepoTags(), this.fluent.getSize(), this.fluent.getVirtualSize());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageInspectBuilder that = (ImageInspectBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

