/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.DefaultNetworkSettings;
import io.fabric8.docker.api.model.DefaultNetworkSettingsFluent;
import io.fabric8.docker.api.model.DefaultNetworkSettingsFluentImpl;
import io.fabric8.docker.api.model.EditableDefaultNetworkSettings;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DefaultNetworkSettingsBuilder
extends DefaultNetworkSettingsFluentImpl<DefaultNetworkSettingsBuilder>
implements VisitableBuilder<DefaultNetworkSettings, DefaultNetworkSettingsBuilder> {
    DefaultNetworkSettingsFluent<?> fluent;

    public DefaultNetworkSettingsBuilder() {
        this(new DefaultNetworkSettings());
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent) {
        this(fluent, new DefaultNetworkSettings());
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent, DefaultNetworkSettings instance) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withGateway(instance.getGateway());
        fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        fluent.withIPAddress(instance.getIPAddress());
        fluent.withIPPrefixLen(instance.getIPPrefixLen());
        fluent.withIPv6Gateway(instance.getIPv6Gateway());
        fluent.withMacAddress(instance.getMacAddress());
    }

    public DefaultNetworkSettingsBuilder(DefaultNetworkSettings instance) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withGateway(instance.getGateway());
        this.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        this.withIPAddress(instance.getIPAddress());
        this.withIPPrefixLen(instance.getIPPrefixLen());
        this.withIPv6Gateway(instance.getIPv6Gateway());
        this.withMacAddress(instance.getMacAddress());
    }

    @Override
    public EditableDefaultNetworkSettings build() {
        EditableDefaultNetworkSettings buildable = new EditableDefaultNetworkSettings(this.fluent.getEndpointID(), this.fluent.getGateway(), this.fluent.getGlobalIPv6Address(), this.fluent.getGlobalIPv6PrefixLen(), this.fluent.getIPAddress(), this.fluent.getIPPrefixLen(), this.fluent.getIPv6Gateway(), this.fluent.getMacAddress());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNetworkSettingsBuilder that = (DefaultNetworkSettingsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

