package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ContainerPathStatFluentImpl<T extends ContainerPathStatFluent<T>> extends BaseFluent<T> implements ContainerPathStatFluent<T>{

     String linkTarget;     Integer mode;     String mtime;     String name;     Long size;     Map<String, Object> additionalProperties = new HashMap();
public ContainerPathStatFluentImpl(){
    
}
public ContainerPathStatFluentImpl( ContainerPathStat instance ){
    this.withLinkTarget(instance.getLinkTarget()); this.withMode(instance.getMode()); this.withMtime(instance.getMtime()); this.withName(instance.getName()); this.withSize(instance.getSize()); 
}

    public String getLinkTarget(){
    return this.linkTarget;
    }
    public T withLinkTarget( String linkTarget){
    this.linkTarget=linkTarget; return (T) this;
    }
    public Integer getMode(){
    return this.mode;
    }
    public T withMode( Integer mode){
    this.mode=mode; return (T) this;
    }
    public String getMtime(){
    return this.mtime;
    }
    public T withMtime( String mtime){
    this.mtime=mtime; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Long getSize(){
    return this.size;
    }
    public T withSize( Long size){
    this.size=size; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerPathStatFluentImpl that = (ContainerPathStatFluentImpl) o;
if (linkTarget != null ? !linkTarget.equals(that.linkTarget) :that.linkTarget != null) return false;
if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
if (mtime != null ? !mtime.equals(that.mtime) :that.mtime != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (size != null ? !size.equals(that.size) :that.size != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
