package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ConfigBuilder extends ConfigFluentImpl<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{

     ConfigFluent<?> fluent;
public ConfigBuilder(){
    this(new Config());
}
public ConfigBuilder( ConfigFluent<?> fluent ){
    this(fluent, new Config());
}
public ConfigBuilder( ConfigFluent<?> fluent , Config instance ){
    this.fluent = fluent; fluent.withAttachStderr(instance.getAttachStderr()); fluent.withAttachStdin(instance.getAttachStdin()); fluent.withAttachStdout(instance.getAttachStdout()); fluent.withCmd(instance.getCmd()); fluent.withDomainname(instance.getDomainname()); fluent.withEntrypoint(instance.getEntrypoint()); fluent.withEnv(instance.getEnv()); fluent.withExposedPorts(instance.getExposedPorts()); fluent.withHostname(instance.getHostname()); fluent.withImage(instance.getImage()); fluent.withLabels(instance.getLabels()); fluent.withMacAddress(instance.getMacAddress()); fluent.withNetworkDisabled(instance.getNetworkDisabled()); fluent.withOnBuild(instance.getOnBuild()); fluent.withOpenStdin(instance.getOpenStdin()); fluent.withPublishService(instance.getPublishService()); fluent.withStdinOnce(instance.getStdinOnce()); fluent.withStopSignal(instance.getStopSignal()); fluent.withTty(instance.getTty()); fluent.withUser(instance.getUser()); fluent.withVolumes(instance.getVolumes()); fluent.withWorkingDir(instance.getWorkingDir()); 
}
public ConfigBuilder( Config instance ){
    this.fluent = this; this.withAttachStderr(instance.getAttachStderr()); this.withAttachStdin(instance.getAttachStdin()); this.withAttachStdout(instance.getAttachStdout()); this.withCmd(instance.getCmd()); this.withDomainname(instance.getDomainname()); this.withEntrypoint(instance.getEntrypoint()); this.withEnv(instance.getEnv()); this.withExposedPorts(instance.getExposedPorts()); this.withHostname(instance.getHostname()); this.withImage(instance.getImage()); this.withLabels(instance.getLabels()); this.withMacAddress(instance.getMacAddress()); this.withNetworkDisabled(instance.getNetworkDisabled()); this.withOnBuild(instance.getOnBuild()); this.withOpenStdin(instance.getOpenStdin()); this.withPublishService(instance.getPublishService()); this.withStdinOnce(instance.getStdinOnce()); this.withStopSignal(instance.getStopSignal()); this.withTty(instance.getTty()); this.withUser(instance.getUser()); this.withVolumes(instance.getVolumes()); this.withWorkingDir(instance.getWorkingDir()); 
}

public EditableConfig build(){
    EditableConfig buildable = new EditableConfig(fluent.isAttachStderr(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.getCmd(),fluent.getDomainname(),fluent.getEntrypoint(),fluent.getEnv(),fluent.getExposedPorts(),fluent.getHostname(),fluent.getImage(),fluent.getLabels(),fluent.getMacAddress(),fluent.isNetworkDisabled(),fluent.getOnBuild(),fluent.isOpenStdin(),fluent.getPublishService(),fluent.isStdinOnce(),fluent.getStopSignal(),fluent.isTty(),fluent.getUser(),fluent.getVolumes(),fluent.getWorkingDir());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ConfigBuilder that = (ConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
