package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class AuthResponseBuilder extends AuthResponseFluentImpl<AuthResponseBuilder> implements VisitableBuilder<AuthResponse,AuthResponseBuilder>{

     AuthResponseFluent<?> fluent;
public AuthResponseBuilder(){
    this(new AuthResponse());
}
public AuthResponseBuilder( AuthResponseFluent<?> fluent ){
    this(fluent, new AuthResponse());
}
public AuthResponseBuilder( AuthResponseFluent<?> fluent , AuthResponse instance ){
    this.fluent = fluent; fluent.withStatus(instance.getStatus()); 
}
public AuthResponseBuilder( AuthResponse instance ){
    this.fluent = this; this.withStatus(instance.getStatus()); 
}

public EditableAuthResponse build(){
    EditableAuthResponse buildable = new EditableAuthResponse(fluent.getStatus());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
AuthResponseBuilder that = (AuthResponseBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
