package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class SearchResultBuilder extends SearchResultFluentImpl<SearchResultBuilder> implements VisitableBuilder<SearchResult,SearchResultBuilder>{

     SearchResultFluent<?> fluent;
public SearchResultBuilder(){
    this(new SearchResult());
}
public SearchResultBuilder( SearchResultFluent<?> fluent ){
    this(fluent, new SearchResult());
}
public SearchResultBuilder( SearchResultFluent<?> fluent , SearchResult instance ){
    this.fluent = fluent; fluent.withDescription(instance.getDescription()); fluent.withIsAutomated(instance.getIsAutomated()); fluent.withIsOfficial(instance.getIsOfficial()); fluent.withIsTrusted(instance.getIsTrusted()); fluent.withName(instance.getName()); fluent.withStarCount(instance.getStarCount()); 
}
public SearchResultBuilder( SearchResult instance ){
    this.fluent = this; this.withDescription(instance.getDescription()); this.withIsAutomated(instance.getIsAutomated()); this.withIsOfficial(instance.getIsOfficial()); this.withIsTrusted(instance.getIsTrusted()); this.withName(instance.getName()); this.withStarCount(instance.getStarCount()); 
}

public EditableSearchResult build(){
    EditableSearchResult buildable = new EditableSearchResult(fluent.getDescription(),fluent.isIsAutomated(),fluent.isIsOfficial(),fluent.isIsTrusted(),fluent.getName(),fluent.getStarCount());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SearchResultBuilder that = (SearchResultBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
