package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.List;
import java.util.AbstractCollection;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.List;
import java.util.List;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;

public class HostConfigFluentImpl<T extends HostConfigFluent<T>> extends BaseFluent<T> implements HostConfigFluent<T>{

     List<String> Binds = new ArrayList();     Integer BlkioWeight;     StrSlice CapAdd;     StrSlice CapDrop;     String CgroupParent;     Object ConsoleSize;     String ContainerIDFile;     Long CpuPeriod;     Long CpuQuota;     Long CpuShares;     String CpusetCpus;     String CpusetMems;     List<VisitableBuilder<DeviceMapping, ?>> Devices = new ArrayList();     List<String> Dns = new ArrayList();     List<String> DnsOptions = new ArrayList();     List<String> DnsSearch = new ArrayList();     List<String> ExtraHosts = new ArrayList();     List<String> GroupAdd = new ArrayList();     String IpcMode;     Long KernelMemory;     List<String> Links = new ArrayList();     VisitableBuilder<LogConfig, ?> LogConfig;     LxcConfig LxcConf;     Long Memory;     Long MemoryReservation;     Long MemorySwap;     Long MemorySwappiness;     String NetworkMode;     Boolean OomKillDisable;     String PidMode;     Map<String, ArrayList<PortBinding>> PortBindings = new HashMap();     Boolean Privileged;     Boolean PublishAllPorts;     Boolean ReadonlyRootfs;     VisitableBuilder<RestartPolicy, ?> RestartPolicy;     List<String> SecurityOpt = new ArrayList();     String UTSMode;     List<VisitableBuilder<Ulimit, ?>> Ulimits = new ArrayList();     String VolumeDriver;     List<String> VolumesFrom = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public HostConfigFluentImpl(){
    
}
public HostConfigFluentImpl( HostConfig instance ){
    this.withBinds(instance.getBinds()); this.withBlkioWeight(instance.getBlkioWeight()); this.withCapAdd(instance.getCapAdd()); this.withCapDrop(instance.getCapDrop()); this.withCgroupParent(instance.getCgroupParent()); this.withConsoleSize(instance.getConsoleSize()); this.withContainerIDFile(instance.getContainerIDFile()); this.withCpuPeriod(instance.getCpuPeriod()); this.withCpuQuota(instance.getCpuQuota()); this.withCpuShares(instance.getCpuShares()); this.withCpusetCpus(instance.getCpusetCpus()); this.withCpusetMems(instance.getCpusetMems()); this.withDevices(instance.getDevices()); this.withDns(instance.getDns()); this.withDnsOptions(instance.getDnsOptions()); this.withDnsSearch(instance.getDnsSearch()); this.withExtraHosts(instance.getExtraHosts()); this.withGroupAdd(instance.getGroupAdd()); this.withIpcMode(instance.getIpcMode()); this.withKernelMemory(instance.getKernelMemory()); this.withLinks(instance.getLinks()); this.withLogConfig(instance.getLogConfig()); this.withLxcConf(instance.getLxcConf()); this.withMemory(instance.getMemory()); this.withMemoryReservation(instance.getMemoryReservation()); this.withMemorySwap(instance.getMemorySwap()); this.withMemorySwappiness(instance.getMemorySwappiness()); this.withNetworkMode(instance.getNetworkMode()); this.withOomKillDisable(instance.getOomKillDisable()); this.withPidMode(instance.getPidMode()); this.withPortBindings(instance.getPortBindings()); this.withPrivileged(instance.getPrivileged()); this.withPublishAllPorts(instance.getPublishAllPorts()); this.withReadonlyRootfs(instance.getReadonlyRootfs()); this.withRestartPolicy(instance.getRestartPolicy()); this.withSecurityOpt(instance.getSecurityOpt()); this.withUTSMode(instance.getUTSMode()); this.withUlimits(instance.getUlimits()); this.withVolumeDriver(instance.getVolumeDriver()); this.withVolumesFrom(instance.getVolumesFrom()); 
}

    public T addToBinds( String ...items){
    for (String item : items) {this.Binds.add(item);} return (T)this;
    }
    public T removeFromBinds( String ...items){
    for (String item : items) {this.Binds.remove(item);} return (T)this;
    }
    public List<String> getBinds(){
    return this.Binds;
    }
    public T withBinds( List<String> Binds){
    this.Binds.clear();if (Binds != null) {for (String item : Binds){this.addToBinds(item);}} return (T) this;
    }
    public T withBinds( String ...Binds){
    this.Binds.clear(); if (Binds != null) {for (String item :Binds){ this.addToBinds(item);}} return (T) this;
    }
    public Integer getBlkioWeight(){
    return this.BlkioWeight;
    }
    public T withBlkioWeight( Integer BlkioWeight){
    this.BlkioWeight=BlkioWeight; return (T) this;
    }
    public StrSlice getCapAdd(){
    return this.CapAdd;
    }
    public T withCapAdd( StrSlice CapAdd){
    this.CapAdd=CapAdd; return (T) this;
    }
    public StrSlice getCapDrop(){
    return this.CapDrop;
    }
    public T withCapDrop( StrSlice CapDrop){
    this.CapDrop=CapDrop; return (T) this;
    }
    public String getCgroupParent(){
    return this.CgroupParent;
    }
    public T withCgroupParent( String CgroupParent){
    this.CgroupParent=CgroupParent; return (T) this;
    }
    public Object getConsoleSize(){
    return this.ConsoleSize;
    }
    public T withConsoleSize( Object ConsoleSize){
    this.ConsoleSize=ConsoleSize; return (T) this;
    }
    public String getContainerIDFile(){
    return this.ContainerIDFile;
    }
    public T withContainerIDFile( String ContainerIDFile){
    this.ContainerIDFile=ContainerIDFile; return (T) this;
    }
    public Long getCpuPeriod(){
    return this.CpuPeriod;
    }
    public T withCpuPeriod( Long CpuPeriod){
    this.CpuPeriod=CpuPeriod; return (T) this;
    }
    public Long getCpuQuota(){
    return this.CpuQuota;
    }
    public T withCpuQuota( Long CpuQuota){
    this.CpuQuota=CpuQuota; return (T) this;
    }
    public Long getCpuShares(){
    return this.CpuShares;
    }
    public T withCpuShares( Long CpuShares){
    this.CpuShares=CpuShares; return (T) this;
    }
    public String getCpusetCpus(){
    return this.CpusetCpus;
    }
    public T withCpusetCpus( String CpusetCpus){
    this.CpusetCpus=CpusetCpus; return (T) this;
    }
    public String getCpusetMems(){
    return this.CpusetMems;
    }
    public T withCpusetMems( String CpusetMems){
    this.CpusetMems=CpusetMems; return (T) this;
    }
    public T addToDevices( DeviceMapping ...items){
    for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.add(builder);this.Devices.add(builder);} return (T)this;
    }
    public T removeFromDevices( DeviceMapping ...items){
    for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.remove(builder);this.Devices.remove(builder);} return (T)this;
    }
    public List<DeviceMapping> getDevices(){
    return build(Devices);
    }
    public T withDevices( List<DeviceMapping> Devices){
    this.Devices.clear();if (Devices != null) {for (DeviceMapping item : Devices){this.addToDevices(item);}} return (T) this;
    }
    public T withDevices( DeviceMapping ...Devices){
    this.Devices.clear(); if (Devices != null) {for (DeviceMapping item :Devices){ this.addToDevices(item);}} return (T) this;
    }
    public DevicesNested<T> addNewDevice(){
    return new DevicesNestedImpl<T>();
    }
    public DevicesNested<T> addNewDeviceLike( DeviceMapping item){
    return new DevicesNestedImpl<T>(item);
    }
    public T addNewDevice( String CgroupPermissions,  String PathInContainer,  String PathOnHost){
    return addToDevices(new DeviceMapping(CgroupPermissions, PathInContainer, PathOnHost));
    }
    public T addToDns( String ...items){
    for (String item : items) {this.Dns.add(item);} return (T)this;
    }
    public T removeFromDns( String ...items){
    for (String item : items) {this.Dns.remove(item);} return (T)this;
    }
    public List<String> getDns(){
    return this.Dns;
    }
    public T withDns( List<String> Dns){
    this.Dns.clear();if (Dns != null) {for (String item : Dns){this.addToDns(item);}} return (T) this;
    }
    public T withDns( String ...Dns){
    this.Dns.clear(); if (Dns != null) {for (String item :Dns){ this.addToDns(item);}} return (T) this;
    }
    public T addToDnsOptions( String ...items){
    for (String item : items) {this.DnsOptions.add(item);} return (T)this;
    }
    public T removeFromDnsOptions( String ...items){
    for (String item : items) {this.DnsOptions.remove(item);} return (T)this;
    }
    public List<String> getDnsOptions(){
    return this.DnsOptions;
    }
    public T withDnsOptions( List<String> DnsOptions){
    this.DnsOptions.clear();if (DnsOptions != null) {for (String item : DnsOptions){this.addToDnsOptions(item);}} return (T) this;
    }
    public T withDnsOptions( String ...DnsOptions){
    this.DnsOptions.clear(); if (DnsOptions != null) {for (String item :DnsOptions){ this.addToDnsOptions(item);}} return (T) this;
    }
    public T addToDnsSearch( String ...items){
    for (String item : items) {this.DnsSearch.add(item);} return (T)this;
    }
    public T removeFromDnsSearch( String ...items){
    for (String item : items) {this.DnsSearch.remove(item);} return (T)this;
    }
    public List<String> getDnsSearch(){
    return this.DnsSearch;
    }
    public T withDnsSearch( List<String> DnsSearch){
    this.DnsSearch.clear();if (DnsSearch != null) {for (String item : DnsSearch){this.addToDnsSearch(item);}} return (T) this;
    }
    public T withDnsSearch( String ...DnsSearch){
    this.DnsSearch.clear(); if (DnsSearch != null) {for (String item :DnsSearch){ this.addToDnsSearch(item);}} return (T) this;
    }
    public T addToExtraHosts( String ...items){
    for (String item : items) {this.ExtraHosts.add(item);} return (T)this;
    }
    public T removeFromExtraHosts( String ...items){
    for (String item : items) {this.ExtraHosts.remove(item);} return (T)this;
    }
    public List<String> getExtraHosts(){
    return this.ExtraHosts;
    }
    public T withExtraHosts( List<String> ExtraHosts){
    this.ExtraHosts.clear();if (ExtraHosts != null) {for (String item : ExtraHosts){this.addToExtraHosts(item);}} return (T) this;
    }
    public T withExtraHosts( String ...ExtraHosts){
    this.ExtraHosts.clear(); if (ExtraHosts != null) {for (String item :ExtraHosts){ this.addToExtraHosts(item);}} return (T) this;
    }
    public T addToGroupAdd( String ...items){
    for (String item : items) {this.GroupAdd.add(item);} return (T)this;
    }
    public T removeFromGroupAdd( String ...items){
    for (String item : items) {this.GroupAdd.remove(item);} return (T)this;
    }
    public List<String> getGroupAdd(){
    return this.GroupAdd;
    }
    public T withGroupAdd( List<String> GroupAdd){
    this.GroupAdd.clear();if (GroupAdd != null) {for (String item : GroupAdd){this.addToGroupAdd(item);}} return (T) this;
    }
    public T withGroupAdd( String ...GroupAdd){
    this.GroupAdd.clear(); if (GroupAdd != null) {for (String item :GroupAdd){ this.addToGroupAdd(item);}} return (T) this;
    }
    public String getIpcMode(){
    return this.IpcMode;
    }
    public T withIpcMode( String IpcMode){
    this.IpcMode=IpcMode; return (T) this;
    }
    public Long getKernelMemory(){
    return this.KernelMemory;
    }
    public T withKernelMemory( Long KernelMemory){
    this.KernelMemory=KernelMemory; return (T) this;
    }
    public T addToLinks( String ...items){
    for (String item : items) {this.Links.add(item);} return (T)this;
    }
    public T removeFromLinks( String ...items){
    for (String item : items) {this.Links.remove(item);} return (T)this;
    }
    public List<String> getLinks(){
    return this.Links;
    }
    public T withLinks( List<String> Links){
    this.Links.clear();if (Links != null) {for (String item : Links){this.addToLinks(item);}} return (T) this;
    }
    public T withLinks( String ...Links){
    this.Links.clear(); if (Links != null) {for (String item :Links){ this.addToLinks(item);}} return (T) this;
    }
    public LogConfig getLogConfig(){
    return this.LogConfig!=null?this.LogConfig.build():null;
    }
    public T withLogConfig( LogConfig LogConfig){
    if (LogConfig!=null){ this.LogConfig= new LogConfigBuilder(LogConfig); _visitables.add(this.LogConfig);} return (T) this;
    }
    public LogConfigNested<T> withNewLogConfig(){
    return new LogConfigNestedImpl<T>();
    }
    public LogConfigNested<T> withNewLogConfigLike( LogConfig item){
    return new LogConfigNestedImpl<T>(item);
    }
    public LogConfigNested<T> editLogConfig(){
    return withNewLogConfigLike(getLogConfig());
    }
    public LxcConfig getLxcConf(){
    return this.LxcConf;
    }
    public T withLxcConf( LxcConfig LxcConf){
    this.LxcConf=LxcConf; return (T) this;
    }
    public Long getMemory(){
    return this.Memory;
    }
    public T withMemory( Long Memory){
    this.Memory=Memory; return (T) this;
    }
    public Long getMemoryReservation(){
    return this.MemoryReservation;
    }
    public T withMemoryReservation( Long MemoryReservation){
    this.MemoryReservation=MemoryReservation; return (T) this;
    }
    public Long getMemorySwap(){
    return this.MemorySwap;
    }
    public T withMemorySwap( Long MemorySwap){
    this.MemorySwap=MemorySwap; return (T) this;
    }
    public Long getMemorySwappiness(){
    return this.MemorySwappiness;
    }
    public T withMemorySwappiness( Long MemorySwappiness){
    this.MemorySwappiness=MemorySwappiness; return (T) this;
    }
    public String getNetworkMode(){
    return this.NetworkMode;
    }
    public T withNetworkMode( String NetworkMode){
    this.NetworkMode=NetworkMode; return (T) this;
    }
    public Boolean isOomKillDisable(){
    return this.OomKillDisable;
    }
    public T withOomKillDisable( Boolean OomKillDisable){
    this.OomKillDisable=OomKillDisable; return (T) this;
    }
    public String getPidMode(){
    return this.PidMode;
    }
    public T withPidMode( String PidMode){
    this.PidMode=PidMode; return (T) this;
    }
    public T addToPortBindings( String key,  ArrayList<PortBinding> value){
    if(key != null && value != null) {this.PortBindings.put(key, value);} return (T)this;
    }
    public T addToPortBindings( Map<String, ArrayList<PortBinding>> map){
    if(map != null) { this.PortBindings.putAll(map);} return (T)this;
    }
    public T removeFromPortBindings( String key){
    if(key != null) {this.PortBindings.remove(key);} return (T)this;
    }
    public T removeFromPortBindings( Map<String, ArrayList<PortBinding>> map){
    if(map != null) { for(Object key : map.keySet()) {this.PortBindings.remove(key);}} return (T)this;
    }
    public Map<String, ArrayList<PortBinding>> getPortBindings(){
    return this.PortBindings;
    }
    public T withPortBindings( Map<String, ArrayList<PortBinding>> PortBindings){
    this.PortBindings.clear();if (PortBindings != null) {this.PortBindings.putAll(PortBindings);} return (T) this;
    }
    public Boolean isPrivileged(){
    return this.Privileged;
    }
    public T withPrivileged( Boolean Privileged){
    this.Privileged=Privileged; return (T) this;
    }
    public Boolean isPublishAllPorts(){
    return this.PublishAllPorts;
    }
    public T withPublishAllPorts( Boolean PublishAllPorts){
    this.PublishAllPorts=PublishAllPorts; return (T) this;
    }
    public Boolean isReadonlyRootfs(){
    return this.ReadonlyRootfs;
    }
    public T withReadonlyRootfs( Boolean ReadonlyRootfs){
    this.ReadonlyRootfs=ReadonlyRootfs; return (T) this;
    }
    public RestartPolicy getRestartPolicy(){
    return this.RestartPolicy!=null?this.RestartPolicy.build():null;
    }
    public T withRestartPolicy( RestartPolicy RestartPolicy){
    if (RestartPolicy!=null){ this.RestartPolicy= new RestartPolicyBuilder(RestartPolicy); _visitables.add(this.RestartPolicy);} return (T) this;
    }
    public RestartPolicyNested<T> withNewRestartPolicy(){
    return new RestartPolicyNestedImpl<T>();
    }
    public RestartPolicyNested<T> withNewRestartPolicyLike( RestartPolicy item){
    return new RestartPolicyNestedImpl<T>(item);
    }
    public RestartPolicyNested<T> editRestartPolicy(){
    return withNewRestartPolicyLike(getRestartPolicy());
    }
    public T withNewRestartPolicy( Integer MaximumRetryCount,  String Name){
    return withRestartPolicy(new RestartPolicy(MaximumRetryCount, Name));
    }
    public T addToSecurityOpt( String ...items){
    for (String item : items) {this.SecurityOpt.add(item);} return (T)this;
    }
    public T removeFromSecurityOpt( String ...items){
    for (String item : items) {this.SecurityOpt.remove(item);} return (T)this;
    }
    public List<String> getSecurityOpt(){
    return this.SecurityOpt;
    }
    public T withSecurityOpt( List<String> SecurityOpt){
    this.SecurityOpt.clear();if (SecurityOpt != null) {for (String item : SecurityOpt){this.addToSecurityOpt(item);}} return (T) this;
    }
    public T withSecurityOpt( String ...SecurityOpt){
    this.SecurityOpt.clear(); if (SecurityOpt != null) {for (String item :SecurityOpt){ this.addToSecurityOpt(item);}} return (T) this;
    }
    public String getUTSMode(){
    return this.UTSMode;
    }
    public T withUTSMode( String UTSMode){
    this.UTSMode=UTSMode; return (T) this;
    }
    public T addToUlimits( Ulimit ...items){
    for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.add(builder);this.Ulimits.add(builder);} return (T)this;
    }
    public T removeFromUlimits( Ulimit ...items){
    for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.remove(builder);this.Ulimits.remove(builder);} return (T)this;
    }
    public List<Ulimit> getUlimits(){
    return build(Ulimits);
    }
    public T withUlimits( List<Ulimit> Ulimits){
    this.Ulimits.clear();if (Ulimits != null) {for (Ulimit item : Ulimits){this.addToUlimits(item);}} return (T) this;
    }
    public T withUlimits( Ulimit ...Ulimits){
    this.Ulimits.clear(); if (Ulimits != null) {for (Ulimit item :Ulimits){ this.addToUlimits(item);}} return (T) this;
    }
    public UlimitsNested<T> addNewUlimit(){
    return new UlimitsNestedImpl<T>();
    }
    public UlimitsNested<T> addNewUlimitLike( Ulimit item){
    return new UlimitsNestedImpl<T>(item);
    }
    public T addNewUlimit( Long Hard,  String Name,  Long Soft){
    return addToUlimits(new Ulimit(Hard, Name, Soft));
    }
    public String getVolumeDriver(){
    return this.VolumeDriver;
    }
    public T withVolumeDriver( String VolumeDriver){
    this.VolumeDriver=VolumeDriver; return (T) this;
    }
    public T addToVolumesFrom( String ...items){
    for (String item : items) {this.VolumesFrom.add(item);} return (T)this;
    }
    public T removeFromVolumesFrom( String ...items){
    for (String item : items) {this.VolumesFrom.remove(item);} return (T)this;
    }
    public List<String> getVolumesFrom(){
    return this.VolumesFrom;
    }
    public T withVolumesFrom( List<String> VolumesFrom){
    this.VolumesFrom.clear();if (VolumesFrom != null) {for (String item : VolumesFrom){this.addToVolumesFrom(item);}} return (T) this;
    }
    public T withVolumesFrom( String ...VolumesFrom){
    this.VolumesFrom.clear(); if (VolumesFrom != null) {for (String item :VolumesFrom){ this.addToVolumesFrom(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HostConfigFluentImpl that = (HostConfigFluentImpl) o;
if (Binds != null ? !Binds.equals(that.Binds) :that.Binds != null) return false;
if (BlkioWeight != null ? !BlkioWeight.equals(that.BlkioWeight) :that.BlkioWeight != null) return false;
if (CapAdd != null ? !CapAdd.equals(that.CapAdd) :that.CapAdd != null) return false;
if (CapDrop != null ? !CapDrop.equals(that.CapDrop) :that.CapDrop != null) return false;
if (CgroupParent != null ? !CgroupParent.equals(that.CgroupParent) :that.CgroupParent != null) return false;
if (ConsoleSize != null &&ConsoleSize != this ? !ConsoleSize.equals(that.ConsoleSize) :that.ConsoleSize != null &&ConsoleSize != this ) return false;
if (ContainerIDFile != null ? !ContainerIDFile.equals(that.ContainerIDFile) :that.ContainerIDFile != null) return false;
if (CpuPeriod != null ? !CpuPeriod.equals(that.CpuPeriod) :that.CpuPeriod != null) return false;
if (CpuQuota != null ? !CpuQuota.equals(that.CpuQuota) :that.CpuQuota != null) return false;
if (CpuShares != null ? !CpuShares.equals(that.CpuShares) :that.CpuShares != null) return false;
if (CpusetCpus != null ? !CpusetCpus.equals(that.CpusetCpus) :that.CpusetCpus != null) return false;
if (CpusetMems != null ? !CpusetMems.equals(that.CpusetMems) :that.CpusetMems != null) return false;
if (Devices != null ? !Devices.equals(that.Devices) :that.Devices != null) return false;
if (Dns != null ? !Dns.equals(that.Dns) :that.Dns != null) return false;
if (DnsOptions != null ? !DnsOptions.equals(that.DnsOptions) :that.DnsOptions != null) return false;
if (DnsSearch != null ? !DnsSearch.equals(that.DnsSearch) :that.DnsSearch != null) return false;
if (ExtraHosts != null ? !ExtraHosts.equals(that.ExtraHosts) :that.ExtraHosts != null) return false;
if (GroupAdd != null ? !GroupAdd.equals(that.GroupAdd) :that.GroupAdd != null) return false;
if (IpcMode != null ? !IpcMode.equals(that.IpcMode) :that.IpcMode != null) return false;
if (KernelMemory != null ? !KernelMemory.equals(that.KernelMemory) :that.KernelMemory != null) return false;
if (Links != null ? !Links.equals(that.Links) :that.Links != null) return false;
if (LogConfig != null ? !LogConfig.equals(that.LogConfig) :that.LogConfig != null) return false;
if (LxcConf != null ? !LxcConf.equals(that.LxcConf) :that.LxcConf != null) return false;
if (Memory != null ? !Memory.equals(that.Memory) :that.Memory != null) return false;
if (MemoryReservation != null ? !MemoryReservation.equals(that.MemoryReservation) :that.MemoryReservation != null) return false;
if (MemorySwap != null ? !MemorySwap.equals(that.MemorySwap) :that.MemorySwap != null) return false;
if (MemorySwappiness != null ? !MemorySwappiness.equals(that.MemorySwappiness) :that.MemorySwappiness != null) return false;
if (NetworkMode != null ? !NetworkMode.equals(that.NetworkMode) :that.NetworkMode != null) return false;
if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
if (PidMode != null ? !PidMode.equals(that.PidMode) :that.PidMode != null) return false;
if (PortBindings != null ? !PortBindings.equals(that.PortBindings) :that.PortBindings != null) return false;
if (Privileged != null ? !Privileged.equals(that.Privileged) :that.Privileged != null) return false;
if (PublishAllPorts != null ? !PublishAllPorts.equals(that.PublishAllPorts) :that.PublishAllPorts != null) return false;
if (ReadonlyRootfs != null ? !ReadonlyRootfs.equals(that.ReadonlyRootfs) :that.ReadonlyRootfs != null) return false;
if (RestartPolicy != null ? !RestartPolicy.equals(that.RestartPolicy) :that.RestartPolicy != null) return false;
if (SecurityOpt != null ? !SecurityOpt.equals(that.SecurityOpt) :that.SecurityOpt != null) return false;
if (UTSMode != null ? !UTSMode.equals(that.UTSMode) :that.UTSMode != null) return false;
if (Ulimits != null ? !Ulimits.equals(that.Ulimits) :that.Ulimits != null) return false;
if (VolumeDriver != null ? !VolumeDriver.equals(that.VolumeDriver) :that.VolumeDriver != null) return false;
if (VolumesFrom != null ? !VolumesFrom.equals(that.VolumesFrom) :that.VolumesFrom != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class DevicesNestedImpl<N> extends DeviceMappingFluentImpl<DevicesNested<N>> implements DevicesNested<N>{

        private final DeviceMappingBuilder builder;
    
             DevicesNestedImpl (){
        this.builder = new DeviceMappingBuilder(this);
        }
             DevicesNestedImpl ( DeviceMapping item){
        this.builder = new DeviceMappingBuilder(this, item);
        }
    
            public N and(){
            return (N) HostConfigFluentImpl.this.addToDevices(builder.build());
        }
            public N endDevice(){
            return and();
        }
    
}
    public class LogConfigNestedImpl<N> extends LogConfigFluentImpl<LogConfigNested<N>> implements LogConfigNested<N>{

        private final LogConfigBuilder builder;
    
             LogConfigNestedImpl ( LogConfig item){
        this.builder = new LogConfigBuilder(this, item);
        }
             LogConfigNestedImpl (){
        this.builder = new LogConfigBuilder(this);
        }
    
            public N and(){
            return (N) HostConfigFluentImpl.this.withLogConfig(builder.build());
        }
            public N endLogConfig(){
            return and();
        }
    
}
    public class RestartPolicyNestedImpl<N> extends RestartPolicyFluentImpl<RestartPolicyNested<N>> implements RestartPolicyNested<N>{

        private final RestartPolicyBuilder builder;
    
             RestartPolicyNestedImpl ( RestartPolicy item){
        this.builder = new RestartPolicyBuilder(this, item);
        }
             RestartPolicyNestedImpl (){
        this.builder = new RestartPolicyBuilder(this);
        }
    
            public N and(){
            return (N) HostConfigFluentImpl.this.withRestartPolicy(builder.build());
        }
            public N endRestartPolicy(){
            return and();
        }
    
}
    public class UlimitsNestedImpl<N> extends UlimitFluentImpl<UlimitsNested<N>> implements UlimitsNested<N>{

        private final UlimitBuilder builder;
    
             UlimitsNestedImpl (){
        this.builder = new UlimitBuilder(this);
        }
             UlimitsNestedImpl ( Ulimit item){
        this.builder = new UlimitBuilder(this, item);
        }
    
            public N and(){
            return (N) HostConfigFluentImpl.this.addToUlimits(builder.build());
        }
            public N endUlimit(){
            return and();
        }
    
}


}
