package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ConfigFluentImpl<T extends ConfigFluent<T>> extends BaseFluent<T> implements ConfigFluent<T>{

     Boolean AttachStderr;     Boolean AttachStdin;     Boolean AttachStdout;     StrSlice Cmd;     String Domainname;     StrSlice Entrypoint;     List<String> Env = new ArrayList();     Map<String, Object> ExposedPorts = new HashMap();     String Hostname;     String Image;     Map<String, String> Labels = new HashMap();     String MacAddress;     Boolean NetworkDisabled;     List<String> OnBuild = new ArrayList();     Boolean OpenStdin;     String PublishService;     Boolean StdinOnce;     String StopSignal;     Boolean Tty;     String User;     Map<String, Object> Volumes = new HashMap();     String WorkingDir;     Map<String, Object> additionalProperties = new HashMap();
public ConfigFluentImpl(){
    
}
public ConfigFluentImpl( Config instance ){
    this.withAttachStderr(instance.getAttachStderr()); this.withAttachStdin(instance.getAttachStdin()); this.withAttachStdout(instance.getAttachStdout()); this.withCmd(instance.getCmd()); this.withDomainname(instance.getDomainname()); this.withEntrypoint(instance.getEntrypoint()); this.withEnv(instance.getEnv()); this.withExposedPorts(instance.getExposedPorts()); this.withHostname(instance.getHostname()); this.withImage(instance.getImage()); this.withLabels(instance.getLabels()); this.withMacAddress(instance.getMacAddress()); this.withNetworkDisabled(instance.getNetworkDisabled()); this.withOnBuild(instance.getOnBuild()); this.withOpenStdin(instance.getOpenStdin()); this.withPublishService(instance.getPublishService()); this.withStdinOnce(instance.getStdinOnce()); this.withStopSignal(instance.getStopSignal()); this.withTty(instance.getTty()); this.withUser(instance.getUser()); this.withVolumes(instance.getVolumes()); this.withWorkingDir(instance.getWorkingDir()); 
}

    public Boolean isAttachStderr(){
    return this.AttachStderr;
    }
    public T withAttachStderr( Boolean AttachStderr){
    this.AttachStderr=AttachStderr; return (T) this;
    }
    public Boolean isAttachStdin(){
    return this.AttachStdin;
    }
    public T withAttachStdin( Boolean AttachStdin){
    this.AttachStdin=AttachStdin; return (T) this;
    }
    public Boolean isAttachStdout(){
    return this.AttachStdout;
    }
    public T withAttachStdout( Boolean AttachStdout){
    this.AttachStdout=AttachStdout; return (T) this;
    }
    public StrSlice getCmd(){
    return this.Cmd;
    }
    public T withCmd( StrSlice Cmd){
    this.Cmd=Cmd; return (T) this;
    }
    public String getDomainname(){
    return this.Domainname;
    }
    public T withDomainname( String Domainname){
    this.Domainname=Domainname; return (T) this;
    }
    public StrSlice getEntrypoint(){
    return this.Entrypoint;
    }
    public T withEntrypoint( StrSlice Entrypoint){
    this.Entrypoint=Entrypoint; return (T) this;
    }
    public T addToEnv( String ...items){
    for (String item : items) {this.Env.add(item);} return (T)this;
    }
    public T removeFromEnv( String ...items){
    for (String item : items) {this.Env.remove(item);} return (T)this;
    }
    public List<String> getEnv(){
    return this.Env;
    }
    public T withEnv( List<String> Env){
    this.Env.clear();if (Env != null) {for (String item : Env){this.addToEnv(item);}} return (T) this;
    }
    public T withEnv( String ...Env){
    this.Env.clear(); if (Env != null) {for (String item :Env){ this.addToEnv(item);}} return (T) this;
    }
    public T addToExposedPorts( String key,  Object value){
    if(key != null && value != null) {this.ExposedPorts.put(key, value);} return (T)this;
    }
    public T addToExposedPorts( Map<String, Object> map){
    if(map != null) { this.ExposedPorts.putAll(map);} return (T)this;
    }
    public T removeFromExposedPorts( String key){
    if(key != null) {this.ExposedPorts.remove(key);} return (T)this;
    }
    public T removeFromExposedPorts( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.ExposedPorts.remove(key);}} return (T)this;
    }
    public Map<String, Object> getExposedPorts(){
    return this.ExposedPorts;
    }
    public T withExposedPorts( Map<String, Object> ExposedPorts){
    this.ExposedPorts.clear();if (ExposedPorts != null) {this.ExposedPorts.putAll(ExposedPorts);} return (T) this;
    }
    public String getHostname(){
    return this.Hostname;
    }
    public T withHostname( String Hostname){
    this.Hostname=Hostname; return (T) this;
    }
    public String getImage(){
    return this.Image;
    }
    public T withImage( String Image){
    this.Image=Image; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.Labels.put(key, value);} return (T)this;
    }
    public T addToLabels( Map<String, String> map){
    if(map != null) { this.Labels.putAll(map);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.Labels.remove(key);} return (T)this;
    }
    public T removeFromLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.Labels.remove(key);}} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.Labels;
    }
    public T withLabels( Map<String, String> Labels){
    this.Labels.clear();if (Labels != null) {this.Labels.putAll(Labels);} return (T) this;
    }
    public String getMacAddress(){
    return this.MacAddress;
    }
    public T withMacAddress( String MacAddress){
    this.MacAddress=MacAddress; return (T) this;
    }
    public Boolean isNetworkDisabled(){
    return this.NetworkDisabled;
    }
    public T withNetworkDisabled( Boolean NetworkDisabled){
    this.NetworkDisabled=NetworkDisabled; return (T) this;
    }
    public T addToOnBuild( String ...items){
    for (String item : items) {this.OnBuild.add(item);} return (T)this;
    }
    public T removeFromOnBuild( String ...items){
    for (String item : items) {this.OnBuild.remove(item);} return (T)this;
    }
    public List<String> getOnBuild(){
    return this.OnBuild;
    }
    public T withOnBuild( List<String> OnBuild){
    this.OnBuild.clear();if (OnBuild != null) {for (String item : OnBuild){this.addToOnBuild(item);}} return (T) this;
    }
    public T withOnBuild( String ...OnBuild){
    this.OnBuild.clear(); if (OnBuild != null) {for (String item :OnBuild){ this.addToOnBuild(item);}} return (T) this;
    }
    public Boolean isOpenStdin(){
    return this.OpenStdin;
    }
    public T withOpenStdin( Boolean OpenStdin){
    this.OpenStdin=OpenStdin; return (T) this;
    }
    public String getPublishService(){
    return this.PublishService;
    }
    public T withPublishService( String PublishService){
    this.PublishService=PublishService; return (T) this;
    }
    public Boolean isStdinOnce(){
    return this.StdinOnce;
    }
    public T withStdinOnce( Boolean StdinOnce){
    this.StdinOnce=StdinOnce; return (T) this;
    }
    public String getStopSignal(){
    return this.StopSignal;
    }
    public T withStopSignal( String StopSignal){
    this.StopSignal=StopSignal; return (T) this;
    }
    public Boolean isTty(){
    return this.Tty;
    }
    public T withTty( Boolean Tty){
    this.Tty=Tty; return (T) this;
    }
    public String getUser(){
    return this.User;
    }
    public T withUser( String User){
    this.User=User; return (T) this;
    }
    public T addToVolumes( String key,  Object value){
    if(key != null && value != null) {this.Volumes.put(key, value);} return (T)this;
    }
    public T addToVolumes( Map<String, Object> map){
    if(map != null) { this.Volumes.putAll(map);} return (T)this;
    }
    public T removeFromVolumes( String key){
    if(key != null) {this.Volumes.remove(key);} return (T)this;
    }
    public T removeFromVolumes( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.Volumes.remove(key);}} return (T)this;
    }
    public Map<String, Object> getVolumes(){
    return this.Volumes;
    }
    public T withVolumes( Map<String, Object> Volumes){
    this.Volumes.clear();if (Volumes != null) {this.Volumes.putAll(Volumes);} return (T) this;
    }
    public String getWorkingDir(){
    return this.WorkingDir;
    }
    public T withWorkingDir( String WorkingDir){
    this.WorkingDir=WorkingDir; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ConfigFluentImpl that = (ConfigFluentImpl) o;
if (AttachStderr != null ? !AttachStderr.equals(that.AttachStderr) :that.AttachStderr != null) return false;
if (AttachStdin != null ? !AttachStdin.equals(that.AttachStdin) :that.AttachStdin != null) return false;
if (AttachStdout != null ? !AttachStdout.equals(that.AttachStdout) :that.AttachStdout != null) return false;
if (Cmd != null ? !Cmd.equals(that.Cmd) :that.Cmd != null) return false;
if (Domainname != null ? !Domainname.equals(that.Domainname) :that.Domainname != null) return false;
if (Entrypoint != null ? !Entrypoint.equals(that.Entrypoint) :that.Entrypoint != null) return false;
if (Env != null ? !Env.equals(that.Env) :that.Env != null) return false;
if (ExposedPorts != null ? !ExposedPorts.equals(that.ExposedPorts) :that.ExposedPorts != null) return false;
if (Hostname != null ? !Hostname.equals(that.Hostname) :that.Hostname != null) return false;
if (Image != null ? !Image.equals(that.Image) :that.Image != null) return false;
if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
if (MacAddress != null ? !MacAddress.equals(that.MacAddress) :that.MacAddress != null) return false;
if (NetworkDisabled != null ? !NetworkDisabled.equals(that.NetworkDisabled) :that.NetworkDisabled != null) return false;
if (OnBuild != null ? !OnBuild.equals(that.OnBuild) :that.OnBuild != null) return false;
if (OpenStdin != null ? !OpenStdin.equals(that.OpenStdin) :that.OpenStdin != null) return false;
if (PublishService != null ? !PublishService.equals(that.PublishService) :that.PublishService != null) return false;
if (StdinOnce != null ? !StdinOnce.equals(that.StdinOnce) :that.StdinOnce != null) return false;
if (StopSignal != null ? !StopSignal.equals(that.StopSignal) :that.StopSignal != null) return false;
if (Tty != null ? !Tty.equals(that.Tty) :that.Tty != null) return false;
if (User != null ? !User.equals(that.User) :that.User != null) return false;
if (Volumes != null ? !Volumes.equals(that.Volumes) :that.Volumes != null) return false;
if (WorkingDir != null ? !WorkingDir.equals(that.WorkingDir) :that.WorkingDir != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
