package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class CPUUsageBuilder extends CPUUsageFluentImpl<CPUUsageBuilder> implements VisitableBuilder<CPUUsage,CPUUsageBuilder>{

     CPUUsageFluent<?> fluent;
public CPUUsageBuilder(){
    this(new CPUUsage());
}
public CPUUsageBuilder( CPUUsageFluent<?> fluent ){
    this(fluent, new CPUUsage());
}
public CPUUsageBuilder( CPUUsageFluent<?> fluent , CPUUsage instance ){
    this.fluent = fluent; fluent.withPercpuUsage(instance.getPercpuUsage()); fluent.withTotalUsage(instance.getTotalUsage()); fluent.withUsageInKernelmode(instance.getUsageInKernelmode()); fluent.withUsageInUsermode(instance.getUsageInUsermode()); 
}
public CPUUsageBuilder( CPUUsage instance ){
    this.fluent = this; this.withPercpuUsage(instance.getPercpuUsage()); this.withTotalUsage(instance.getTotalUsage()); this.withUsageInKernelmode(instance.getUsageInKernelmode()); this.withUsageInUsermode(instance.getUsageInUsermode()); 
}

public EditableCPUUsage build(){
    EditableCPUUsage buildable = new EditableCPUUsage(fluent.getPercpuUsage(),fluent.getTotalUsage(),fluent.getUsageInKernelmode(),fluent.getUsageInUsermode());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CPUUsageBuilder that = (CPUUsageBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
