/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.property;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.AttestationConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.BuildXConfiguration;
import io.fabric8.maven.docker.config.CopyConfiguration;
import io.fabric8.maven.docker.config.HealthCheckConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RestartPolicy;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import io.fabric8.maven.docker.config.handler.property.ConfigKey;
import io.fabric8.maven.docker.config.handler.property.PropertyMode;
import io.fabric8.maven.docker.config.handler.property.ValueProvider;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.CollectionUtils;

public class PropertyConfigHandler
implements ExternalConfigHandler {
    public static final String TYPE_NAME = "properties";
    public static final String DEFAULT_PREFIX = "docker";

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration fromConfig, MavenProject project, MavenSession session) throws IllegalArgumentException {
        Map<String, String> externalConfig = fromConfig.getExternalConfig();
        String prefix = PropertyConfigHandler.getPrefix(externalConfig);
        Properties properties = EnvUtil.getPropertiesWithSystemOverrides(project);
        PropertyMode propertyMode = PropertyConfigHandler.getMode(externalConfig);
        ValueProvider valueProvider = new ValueProvider(prefix, properties, propertyMode);
        RunImageConfiguration run = this.extractRunConfiguration(fromConfig, valueProvider);
        BuildImageConfiguration build = this.extractBuildConfiguration(fromConfig, valueProvider, project);
        WatchImageConfiguration watch = this.extractWatchConfig(fromConfig, valueProvider);
        CopyConfiguration copyConfig = this.extractCopyConfig(fromConfig, valueProvider);
        String name = valueProvider.getString(ConfigKey.NAME, fromConfig.getName());
        String alias = valueProvider.getString(ConfigKey.ALIAS, fromConfig.getAlias());
        String removeNamePattern = valueProvider.getString(ConfigKey.REMOVE_NAME_PATTERN, fromConfig.getRemoveNamePattern());
        String copyNamePattern = valueProvider.getString(ConfigKey.COPY_NAME_PATTERN, fromConfig.getCopyNamePattern());
        String stopNamePattern = valueProvider.getString(ConfigKey.STOP_NAME_PATTERN, fromConfig.getStopNamePattern());
        if (name == null) {
            throw new IllegalArgumentException(String.format("Mandatory property [%s] is not defined", new Object[]{ConfigKey.NAME}));
        }
        return Collections.singletonList(new ImageConfiguration.Builder().name(name).alias(alias).removeNamePattern(removeNamePattern).copyNamePattern(copyNamePattern).stopNamePattern(stopNamePattern).runConfig(run).buildConfig(build).watchConfig(watch).copyConfig(copyConfig).build());
    }

    private boolean isStringValueNull(ValueProvider valueProvider, ConfigKey key, Supplier<String> supplier) {
        return valueProvider.getString(key, supplier.get()) != null;
    }

    private boolean buildConfigured(BuildImageConfiguration config, ValueProvider valueProvider, MavenProject project) {
        if (this.isStringValueNull(valueProvider, ConfigKey.FROM, config::getFrom)) {
            return true;
        }
        if (valueProvider.getMap(ConfigKey.FROM_EXT, config.getFromExt()) != null) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, ConfigKey.DOCKER_FILE, config::getDockerFileRaw)) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, ConfigKey.DOCKER_ARCHIVE, config::getDockerArchiveRaw)) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, ConfigKey.CONTEXT_DIR, config::getContextDirRaw)) {
            return true;
        }
        if (this.isStringValueNull(valueProvider, ConfigKey.DOCKER_FILE_DIR, config::getDockerFileDirRaw)) {
            return true;
        }
        return new File(project.getBasedir(), "Dockerfile").exists();
    }

    private BuildImageConfiguration extractBuildConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider, MavenProject project) {
        BuildImageConfiguration config = fromConfig.getBuildConfiguration();
        if (config == null) {
            config = new BuildImageConfiguration();
        }
        if (!this.buildConfigured(config, valueProvider, project)) {
            return null;
        }
        BuildImageConfiguration.Builder builder = new BuildImageConfiguration.Builder();
        builder.cmd(this.extractArguments(valueProvider, ConfigKey.CMD, config.getCmd())).cleanup(valueProvider.getString(ConfigKey.CLEANUP, config.getCleanup())).noCache(valueProvider.getBoolean(ConfigKey.NO_CACHE, config.getNoCache())).squash(valueProvider.getBoolean(ConfigKey.SQUASH, config.getSquash())).cacheFrom(valueProvider.getList(ConfigKey.CACHE_FROM, config.getCacheFrom())).optimise(valueProvider.getBoolean(ConfigKey.OPTIMISE, config.getOptimise())).entryPoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, config.getEntryPoint())).assembly(this.extractAssembly(config.getAssemblyConfiguration(), valueProvider)).assemblies(this.extractAssemblies(config.getAssembliesConfiguration(), valueProvider)).env(CollectionUtils.mergeMaps(valueProvider.getMap(ConfigKey.ENV_BUILD, config.getEnv()), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).args(valueProvider.getMap(ConfigKey.ARGS, config.getArgs())).labels(valueProvider.getMap(ConfigKey.LABELS, config.getLabels())).ports(this.extractPortValues(config.getPorts(), valueProvider)).shell(this.extractArguments(valueProvider, ConfigKey.SHELL, config.getShell())).runCmds(valueProvider.getList(ConfigKey.RUN, config.getRunCmds())).from(valueProvider.getString(ConfigKey.FROM, config.getFrom())).fromExt(valueProvider.getMap(ConfigKey.FROM_EXT, config.getFromExt())).registry(valueProvider.getString(ConfigKey.REGISTRY, config.getRegistry())).volumes(valueProvider.getList(ConfigKey.VOLUMES, config.getVolumes())).tags(valueProvider.getList(ConfigKey.TAGS, config.getTags())).maintainer(valueProvider.getString(ConfigKey.MAINTAINER, config.getMaintainer())).network(valueProvider.getString(ConfigKey.BUILD_NETWORK, config.getNetwork())).workdir(valueProvider.getString(ConfigKey.WORKDIR, config.getWorkdir())).skip(valueProvider.getBoolean(ConfigKey.SKIP_BUILD, config.getSkip())).skipPush(valueProvider.getBoolean(ConfigKey.SKIP_PUSH, config.getSkipPush())).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_BUILD, config.getImagePullPolicy())).contextDir(valueProvider.getString(ConfigKey.CONTEXT_DIR, config.getContextDirRaw())).dockerArchive(valueProvider.getString(ConfigKey.DOCKER_ARCHIVE, config.getDockerArchiveRaw())).loadNamePattern(valueProvider.getString(ConfigKey.LOAD_NAME_PATTERN, config.getLoadNamePattern())).dockerFile(valueProvider.getString(ConfigKey.DOCKER_FILE, config.getDockerFileRaw())).dockerFileDir(valueProvider.getString(ConfigKey.DOCKER_FILE_DIR, config.getDockerFileDirRaw())).buildOptions(valueProvider.getMap(ConfigKey.BUILD_OPTIONS, config.getBuildOptions())).useDefaultExcludes(valueProvider.getBoolean(ConfigKey.USE_DEFAULT_EXCLUDES, config.getUseDefaultExcludes())).filter(valueProvider.getString(ConfigKey.FILTER, config.getFilterRaw())).user(valueProvider.getString(ConfigKey.USER, config.getUser())).healthCheck(this.extractHealthCheck(config.getHealthCheck(), valueProvider)).buildx(this.extractBuildx(config.getBuildX(), valueProvider));
        return builder.build();
    }

    private RunImageConfiguration extractRunConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        RunImageConfiguration config = fromConfig.getRunConfiguration();
        if (config == null) {
            config = new RunImageConfiguration();
        }
        return new RunImageConfiguration.Builder().capAdd(valueProvider.getList(ConfigKey.CAP_ADD, config.getCapAdd())).capDrop(valueProvider.getList(ConfigKey.CAP_DROP, config.getCapDrop())).sysctls(valueProvider.getMap(ConfigKey.SYSCTLS, config.getSysctls())).securityOpts(valueProvider.getList(ConfigKey.SECURITY_OPTS, config.getSecurityOpts())).cmd(this.extractArguments(valueProvider, ConfigKey.CMD, config.getCmd())).dns(valueProvider.getList(ConfigKey.DNS, config.getDns())).dependsOn(valueProvider.getList(ConfigKey.DEPENDS_ON, config.getDependsOn())).net(valueProvider.getString(ConfigKey.NET, config.getNetRaw())).network(this.extractNetworkConfig(config.getNetworkingConfig(), valueProvider)).dnsSearch(valueProvider.getList(ConfigKey.DNS_SEARCH, config.getDnsSearch())).domainname(valueProvider.getString(ConfigKey.DOMAINNAME, config.getDomainname())).entrypoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, config.getEntrypoint())).env(CollectionUtils.mergeMaps(valueProvider.getMap(ConfigKey.ENV_RUN, config.getEnv()), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).labels(valueProvider.getMap(ConfigKey.LABELS, config.getLabels())).envPropertyFile(valueProvider.getString(ConfigKey.ENV_PROPERTY_FILE, config.getEnvPropertyFile())).extraHosts(valueProvider.getList(ConfigKey.EXTRA_HOSTS, config.getExtraHosts())).hostname(valueProvider.getString(ConfigKey.HOSTNAME, config.getHostname())).links(valueProvider.getList(ConfigKey.LINKS, config.getLinks())).memory(valueProvider.getLong(ConfigKey.MEMORY, config.getMemory())).memorySwap(valueProvider.getLong(ConfigKey.MEMORY_SWAP, config.getMemorySwap())).namingStrategy(valueProvider.getString(ConfigKey.NAMING_STRATEGY, config.getNamingStrategy() == null ? null : config.getNamingStrategy().name())).exposedPropertyKey(valueProvider.getString(ConfigKey.EXPOSED_PROPERTY_KEY, config.getExposedPropertyKey())).portPropertyFile(valueProvider.getString(ConfigKey.PORT_PROPERTY_FILE, config.getPortPropertyFile())).ports(valueProvider.getList(ConfigKey.PORTS, config.getPorts())).shmSize(valueProvider.getLong(ConfigKey.SHMSIZE, config.getShmSize())).privileged(valueProvider.getBoolean(ConfigKey.PRIVILEGED, config.getPrivileged())).restartPolicy(this.extractRestartPolicy(config.getRestartPolicy(), valueProvider)).user(valueProvider.getString(ConfigKey.USER, config.getUser())).workingDir(valueProvider.getString(ConfigKey.WORKING_DIR, config.getWorkingDir())).log(this.extractLogConfig(config.getLogConfiguration(), valueProvider)).wait(this.extractWaitConfig(config.getWaitConfiguration(), valueProvider)).volumes(this.extractVolumeConfig(config.getVolumeConfiguration(), valueProvider)).skip(valueProvider.getBoolean(ConfigKey.SKIP_RUN, config.getSkip())).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_RUN, config.getImagePullPolicy())).platform(valueProvider.getString(ConfigKey.PLATFORM, config.getPlatform())).ulimits(this.extractUlimits(config.getUlimits(), valueProvider)).tmpfs(valueProvider.getList(ConfigKey.TMPFS, config.getTmpfs())).isolation(valueProvider.getString(ConfigKey.ISOLATION, config.getIsolation())).cpuShares(valueProvider.getLong(ConfigKey.CPUSHARES, config.getCpuShares())).cpus(valueProvider.getDouble(ConfigKey.CPUS, config.getCpus())).cpuSet(valueProvider.getString(ConfigKey.CPUSET, config.getCpuSet())).readOnly(valueProvider.getBoolean(ConfigKey.READ_ONLY, config.getReadOnly())).autoRemove(valueProvider.getBoolean(ConfigKey.AUTO_REMOVE, config.getAutoRemove())).build();
    }

    private NetworkConfig extractNetworkConfig(NetworkConfig config, ValueProvider valueProvider) {
        if (config == null) {
            config = new NetworkConfig();
        }
        return new NetworkConfig.Builder().mode(valueProvider.getString(ConfigKey.NETWORK_MODE, config.getMode() == null ? null : config.getMode().name())).name(valueProvider.getString(ConfigKey.NETWORK_NAME, config.getName())).aliases(valueProvider.getList(ConfigKey.NETWORK_ALIAS, config.getAliases())).build();
    }

    private List<AssemblyConfiguration> extractAssemblies(List<AssemblyConfiguration> config, ValueProvider valueProvider) {
        List<ValueProvider> assemblyConfigProviders = valueProvider.getNestedList(ConfigKey.ASSEMBLIES);
        ArrayList<AssemblyConfiguration> assemblies = new ArrayList<AssemblyConfiguration>();
        int count = Math.max(assemblyConfigProviders.size(), config == null ? 0 : config.size());
        for (int i = 0; i < count; ++i) {
            AssemblyConfiguration fromConfig;
            AssemblyConfiguration assemblyConfiguration = fromConfig = config == null || i >= config.size() ? null : config.get(i);
            if (i >= assemblyConfigProviders.size()) {
                assemblies.add(fromConfig);
                continue;
            }
            ValueProvider provider = assemblyConfigProviders.get(i);
            assemblies.add(this.extractAssembly(fromConfig, provider));
        }
        return assemblies;
    }

    private AssemblyConfiguration extractAssembly(AssemblyConfiguration config, ValueProvider valueProvider) {
        Map<String, String> assemblyProperties = valueProvider.getMap(ConfigKey.ASSEMBLY, Collections.emptyMap());
        if (assemblyProperties == null || assemblyProperties.isEmpty()) {
            return config;
        }
        if (config == null) {
            config = new AssemblyConfiguration();
        }
        AssemblyConfiguration.Builder builder = new AssemblyConfiguration.Builder().targetDir(valueProvider.getString(ConfigKey.ASSEMBLY_BASEDIR, config.getTargetDir())).descriptor(valueProvider.getString(ConfigKey.ASSEMBLY_DESCRIPTOR, config.getDescriptor())).descriptorRef(valueProvider.getString(ConfigKey.ASSEMBLY_DESCRIPTOR_REF, config.getDescriptorRef())).dockerFileDir(valueProvider.getString(ConfigKey.ASSEMBLY_DOCKER_FILE_DIR, config.getDockerFileDir())).exportBasedir(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXPORT_BASEDIR, config.getExportTargetDir())).ignorePermissions(valueProvider.getBoolean(ConfigKey.ASSEMBLY_IGNORE_PERMISSIONS, config.getIgnorePermissions())).permissions(valueProvider.getString(ConfigKey.ASSEMBLY_PERMISSIONS, config.getPermissionsRaw())).user(valueProvider.getString(ConfigKey.ASSEMBLY_USER, config.getUser())).mode(valueProvider.getString(ConfigKey.ASSEMBLY_MODE, config.getModeRaw())).assemblyDef(config.getInline()).tarLongFileMode(valueProvider.getString(ConfigKey.ASSEMBLY_TARLONGFILEMODE, config.getTarLongFileMode()));
        String name = valueProvider.getString(ConfigKey.ASSEMBLY_NAME, config.getName());
        if (name != null) {
            builder.name(name);
        }
        return builder.build();
    }

    private HealthCheckConfiguration extractHealthCheck(HealthCheckConfiguration config, ValueProvider valueProvider) {
        Map<String, String> healthCheckProperties = valueProvider.getMap(ConfigKey.HEALTHCHECK, Collections.emptyMap());
        if (healthCheckProperties == null || healthCheckProperties.isEmpty()) {
            return config;
        }
        if (config == null) {
            config = new HealthCheckConfiguration();
        }
        return new HealthCheckConfiguration.Builder().interval(valueProvider.getString(ConfigKey.HEALTHCHECK_INTERVAL, config.getInterval())).timeout(valueProvider.getString(ConfigKey.HEALTHCHECK_TIMEOUT, config.getTimeout())).startPeriod(valueProvider.getString(ConfigKey.HEALTHCHECK_START_PERIOD, config.getStartPeriod())).retries(valueProvider.getInteger(ConfigKey.HEALTHCHECK_RETRIES, config.getRetries())).mode(valueProvider.getString(ConfigKey.HEALTHCHECK_MODE, config.getMode() == null ? null : config.getMode().name())).cmd(this.extractArguments(valueProvider, ConfigKey.HEALTHCHECK_CMD, config.getCmd())).build();
    }

    private BuildXConfiguration extractBuildx(BuildXConfiguration config, ValueProvider valueProvider) {
        if (config == null) {
            config = new BuildXConfiguration();
        }
        return new BuildXConfiguration.Builder().builderName(valueProvider.getString(ConfigKey.BUILDX_BUILDERNAME, config.getBuilderName())).nodeName(valueProvider.getString(ConfigKey.BUILDX_NODENAME, config.getNodeName())).configFile(valueProvider.getString(ConfigKey.BUILDX_CONFIGFILE, config.getConfigFile())).dockerStateDir(valueProvider.getString(ConfigKey.BUILDX_DOCKERSTATEDIR, config.getDockerStateDir())).platforms(valueProvider.getList(ConfigKey.BUILDX_PLATFORMS, config.getPlatforms())).attestations(this.extractAttestations(config.getAttestations(), valueProvider)).cacheFrom(valueProvider.getString(ConfigKey.BUILDX_CACHE_FROM, config.getCacheFrom())).cacheTo(valueProvider.getString(ConfigKey.BUILDX_CACHE_TO, config.getCacheTo())).build();
    }

    private AttestationConfiguration extractAttestations(AttestationConfiguration config, ValueProvider valueProvider) {
        if (config == null) {
            config = new AttestationConfiguration();
        }
        return new AttestationConfiguration.Builder().provenance(valueProvider.getString(ConfigKey.BUILDX_ATTESTATION_PROVENANCE, config.getProvenance())).sbom(valueProvider.getBoolean(ConfigKey.BUILDX_ATTESTATION_SBOM, config.getSbom())).build();
    }

    private List<String> extractPortValues(List<String> config, ValueProvider valueProvider) {
        List<String> ports = valueProvider.getList(ConfigKey.PORTS, config);
        if (ports == null || ports.isEmpty()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        List<String[]> parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private Arguments extractArguments(ValueProvider valueProvider, ConfigKey configKey, Arguments alternative) {
        return valueProvider.getObject(configKey, alternative, raw -> raw != null ? new Arguments((String)raw) : null);
    }

    private RestartPolicy extractRestartPolicy(RestartPolicy config, ValueProvider valueProvider) {
        if (config == null) {
            config = new RestartPolicy();
        }
        return new RestartPolicy.Builder().name(valueProvider.getString(ConfigKey.RESTART_POLICY_NAME, config.getName())).retry(valueProvider.getInt(ConfigKey.RESTART_POLICY_RETRY, config.getRetry() == 0 ? null : Integer.valueOf(config.getRetry()))).build();
    }

    private LogConfiguration extractLogConfig(LogConfiguration config, ValueProvider valueProvider) {
        if (config == null) {
            config = new LogConfiguration();
        }
        return new LogConfiguration.Builder().color(valueProvider.getString(ConfigKey.LOG_COLOR, config.getColor())).date(valueProvider.getString(ConfigKey.LOG_DATE, config.getDate())).file(valueProvider.getString(ConfigKey.LOG_FILE, config.getFileLocation())).prefix(valueProvider.getString(ConfigKey.LOG_PREFIX, config.getPrefix())).logDriverName(valueProvider.getString(ConfigKey.LOG_DRIVER_NAME, config.getDriver() == null ? null : config.getDriver().getName())).logDriverOpts(valueProvider.getMap(ConfigKey.LOG_DRIVER_OPTS, config.getDriver() == null ? null : config.getDriver().getOpts())).enabled(valueProvider.getBoolean(ConfigKey.LOG_ENABLED, config.isEnabled())).build();
    }

    private WaitConfiguration extractWaitConfig(WaitConfiguration config, ValueProvider valueProvider) {
        String url;
        WaitConfiguration.TcpConfiguration tcp;
        WaitConfiguration.HttpConfiguration http;
        WaitConfiguration.ExecConfiguration exec;
        if (config == null) {
            config = new WaitConfiguration();
        }
        if ((exec = config.getExec()) == null) {
            exec = new WaitConfiguration.ExecConfiguration();
        }
        if ((http = config.getHttp()) == null) {
            http = new WaitConfiguration.HttpConfiguration();
        }
        if ((tcp = config.getTcp()) == null) {
            tcp = new WaitConfiguration.TcpConfiguration();
        }
        if ((url = valueProvider.getString(ConfigKey.WAIT_HTTP_URL, config.getUrl())) == null) {
            url = valueProvider.getString(ConfigKey.WAIT_URL, config.getUrl());
        }
        return new WaitConfiguration.Builder().time(valueProvider.getInt(ConfigKey.WAIT_TIME, config.getTime())).healthy(valueProvider.getBoolean(ConfigKey.WAIT_HEALTHY, config.getHealthy())).url(url).preStop(valueProvider.getString(ConfigKey.WAIT_EXEC_PRE_STOP, exec.getPreStop())).postStart(valueProvider.getString(ConfigKey.WAIT_EXEC_POST_START, exec.getPostStart())).breakOnError(valueProvider.getBoolean(ConfigKey.WAIT_EXEC_BREAK_ON_ERROR, exec.isBreakOnError())).method(valueProvider.getString(ConfigKey.WAIT_HTTP_METHOD, http.getMethod())).status(valueProvider.getString(ConfigKey.WAIT_HTTP_STATUS, http.getStatus())).log(valueProvider.getString(ConfigKey.WAIT_LOG, config.getLog())).kill(valueProvider.getInteger(ConfigKey.WAIT_KILL, config.getKill())).exit(valueProvider.getInteger(ConfigKey.WAIT_EXIT, config.getExit())).shutdown(valueProvider.getInteger(ConfigKey.WAIT_SHUTDOWN, config.getShutdown())).tcpHost(valueProvider.getString(ConfigKey.WAIT_TCP_HOST, tcp.getHost())).tcpPorts(valueProvider.getIntList(ConfigKey.WAIT_TCP_PORT, tcp.getPorts())).tcpMode(valueProvider.getString(ConfigKey.WAIT_TCP_MODE, tcp.getMode() == null ? null : tcp.getMode().name())).build();
    }

    private WatchImageConfiguration extractWatchConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        WatchImageConfiguration config = fromConfig.getWatchConfiguration();
        if (config == null) {
            config = new WatchImageConfiguration();
        }
        return new WatchImageConfiguration.Builder().interval(valueProvider.getInteger(ConfigKey.WATCH_INTERVAL, config.getIntervalRaw())).postGoal(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config.getPostGoal())).postExec(valueProvider.getString(ConfigKey.WATCH_POSTEXEC, config.getPostExec())).mode(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config.getMode() == null ? null : config.getMode().name())).build();
    }

    private CopyConfiguration extractCopyConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        CopyConfiguration config = fromConfig.getCopyConfiguration();
        if (config == null) {
            config = new CopyConfiguration();
        }
        return new CopyConfiguration.Builder().entriesAsListOfProperties(valueProvider.getPropertiesList(ConfigKey.COPY_ENTRIES, config.getEntriesAsListOfProperties())).build();
    }

    private List<UlimitConfig> extractUlimits(List<UlimitConfig> config, ValueProvider valueProvider) {
        List<String> ulimits;
        ArrayList<String> other = null;
        if (config != null) {
            other = new ArrayList<String>();
            for (UlimitConfig ulimitConfig : config) {
                other.add(ulimitConfig.serialize());
            }
        }
        if ((ulimits = valueProvider.getList(ConfigKey.ULIMITS, other)) == null) {
            return null;
        }
        ArrayList<UlimitConfig> ret = new ArrayList<UlimitConfig>();
        for (String ulimit : ulimits) {
            ret.add(new UlimitConfig(ulimit));
        }
        return ret;
    }

    private RunVolumeConfiguration extractVolumeConfig(RunVolumeConfiguration config, ValueProvider valueProvider) {
        if (config == null) {
            config = new RunVolumeConfiguration();
        }
        return new RunVolumeConfiguration.Builder().bind(valueProvider.getList(ConfigKey.BIND, config.getBind())).from(valueProvider.getList(ConfigKey.VOLUMES_FROM, config.getFrom())).build();
    }

    private static String getPrefix(Map<String, String> externalConfig) {
        String prefix = externalConfig.get("prefix");
        if (prefix == null) {
            prefix = DEFAULT_PREFIX;
        }
        return prefix;
    }

    private static PropertyMode getMode(Map<String, String> externalConfig) {
        return PropertyMode.parse(externalConfig.get("mode"));
    }

    public static boolean canCoexistWithOtherPropertyConfiguredImages(Map<String, String> externalConfig) {
        if (externalConfig == null || externalConfig.isEmpty()) {
            return false;
        }
        if (!TYPE_NAME.equals(externalConfig.get("type"))) {
            return true;
        }
        return externalConfig.get("prefix") != null;
    }
}

