/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.BuildOptions;
import io.fabric8.maven.docker.access.CreateImageOptions;
import io.fabric8.maven.docker.util.ImageName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public final class UrlBuilder {
    private final String apiVersion;
    private final String baseUrl;

    public UrlBuilder(String baseUrl, String apiVersion) {
        this.apiVersion = apiVersion;
        this.baseUrl = this.stripSlash(baseUrl);
    }

    public String buildImage(String image, BuildOptions options) {
        Builder urlBuilder = this.u("build", new String[0]).p("t", image);
        if (options != null) {
            urlBuilder.p(options.getOptions());
        }
        return urlBuilder.build();
    }

    public String copyArchive(String containerId, String targetPath) {
        return this.u("containers/%s/archive", containerId).p("path", targetPath).build();
    }

    public String inspectImage(String name) {
        return this.u("images/%s/json", name).build();
    }

    public String listImages(boolean all) {
        return this.u("images/json", new String[0]).p("all", all).build();
    }

    public String containerLogs(String containerId, boolean follow) {
        return this.u("containers/%s/logs", containerId).p("stdout", true).p("stderr", true).p("timestamps", true).p("follow", follow).build();
    }

    public String createContainer(String name, String platform) {
        return this.u("containers/create", new String[0]).p("name", name).p("platform", platform).build();
    }

    public String version() {
        return String.format("%s/version", this.baseUrl);
    }

    public String deleteImage(String name, boolean force) {
        return this.u("images/%s", name).p("force", force).build();
    }

    public String getImage(ImageName name) {
        return this.u("images/%s/get", name.getFullName()).build();
    }

    public String inspectContainer(String containerId) {
        return this.u("containers/%s/json", containerId).build();
    }

    public String inspectExecContainer(String containerId) {
        return this.u("exec/%s/json", containerId).build();
    }

    public String listContainers(boolean all, String ... filter) {
        Builder builder = this.u("containers/json", new String[0]).p("all", all);
        this.addFilters(builder, filter);
        return builder.build();
    }

    public String loadImage() {
        return this.u("images/load", new String[0]).build();
    }

    public String pullImage(CreateImageOptions options) {
        Builder urlBuilder = this.u("images/create", new String[0]);
        if (options != null) {
            urlBuilder.p(options.getOptions());
        }
        return urlBuilder.build();
    }

    public String pushImage(ImageName name, String registry) {
        return this.u("images/%s/push", name.getNameWithoutTag(registry)).p("tag", name.getTag()).p("force", true).build();
    }

    public String removeContainer(String containerId, boolean removeVolumes) {
        return this.u("containers/%s", containerId).p("v", removeVolumes).build();
    }

    public String startContainer(String containerId) {
        return this.u("containers/%s/start", containerId).build();
    }

    public String createExecContainer(String containerId) {
        return this.u("containers/%s/exec", containerId).build();
    }

    public String startExecContainer(String containerId) {
        return this.u("exec/%s/start", containerId).build();
    }

    public String stopContainer(String containerId, int killWait) {
        Builder b = this.u("containers/%s/stop", containerId);
        if (killWait > 0) {
            b.p("t", killWait);
        }
        return b.build();
    }

    public String killContainer(String containerId) {
        Builder b = this.u("containers/%s/kill", containerId);
        return b.build();
    }

    public String tagContainer(ImageName source, ImageName target, boolean force) {
        return this.u("images/%s/tag", source.getFullName()).p("repo", target.getNameWithoutTag()).p("tag", target.getTag()).p("force", force).build();
    }

    public String listNetworks() {
        return this.u("networks", new String[0]).build();
    }

    public String createNetwork() {
        return this.u("networks/create", new String[0]).build();
    }

    public String removeNetwork(String id) {
        return this.u("networks/%s", id).build();
    }

    public String createVolume() {
        return this.u("volumes/create", new String[0]).build();
    }

    public String removeVolume(String name) {
        return this.u("volumes/%s", name).build();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private static String encode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(param);
        }
    }

    private String stripSlash(String url) {
        String ret = url;
        while (ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private Builder u(String format, String ... args) {
        return new Builder(this.createUrl(String.format(format, this.encodeArgs(args))));
    }

    private String[] encodeArgs(String[] args) {
        String[] ret = new String[args.length];
        int i = 0;
        for (String arg : args) {
            ret[i++] = UrlBuilder.encode(arg);
        }
        return ret;
    }

    private String createUrl(String path) {
        return String.format("%s/%s/%s", this.baseUrl, this.apiVersion, path);
    }

    private void addFilters(Builder builder, String ... filter) {
        if (filter.length > 0) {
            if (filter.length % 2 != 0) {
                throw new IllegalArgumentException("Filters must be given as key value pairs and not " + Arrays.asList(filter));
            }
            JsonObject filters = new JsonObject();
            for (int i = 0; i < filter.length; i += 2) {
                JsonArray value = new JsonArray();
                value.add(filter[i + 1]);
                filters.add(filter[i], (JsonElement)value);
            }
            builder.p("filters", filters.toString());
        }
    }

    private static class Builder {
        private Map<String, String> queryParams = new HashMap<String, String>();
        private String url;

        public Builder(String url) {
            this.url = url;
        }

        private Builder p(Map<String, String> params) {
            this.queryParams.putAll(params);
            return this;
        }

        private Builder p(String key, String value) {
            if (value != null) {
                this.queryParams.put(key, value);
            }
            return this;
        }

        private Builder p(String key, boolean value) {
            return this.p(key, value ? "1" : "0");
        }

        private Builder p(String key, int value) {
            return this.p(key, Integer.toString(value));
        }

        public String build() {
            if (this.queryParams.size() > 0) {
                StringBuilder ret = new StringBuilder(this.url);
                ret.append("?");
                for (String key : new TreeSet<String>(this.queryParams.keySet())) {
                    ret.append(key).append("=").append(UrlBuilder.encode(this.queryParams.get(key))).append("&");
                }
                return ret.substring(0, ret.length() - 1);
            }
            return this.url;
        }
    }
}

