/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.service.JibBuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.MojoParameters;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY)
public class PushMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.push.registry")
    private String pushRegistry;
    @Parameter(property="docker.skip.push", defaultValue="false")
    boolean skipPush;
    @Parameter(property="docker.skip.tag", defaultValue="false")
    private boolean skipTag;
    @Parameter(property="docker.push.retries", defaultValue="0")
    private int retries;

    @Override
    public void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipPush || this.shouldSkipPom()) {
            return;
        }
        if (Boolean.TRUE.equals(this.jib)) {
            this.executeJibPush(hub);
        } else {
            this.executeDockerPush(hub);
        }
    }

    private void executeDockerPush(ServiceHub hub) throws MojoExecutionException, DockerAccessException {
        hub.getRegistryService().pushImages(this.createProjectPaths(), this.getResolvedImages(), this.retries, this.getRegistryConfig(this.pushRegistry), this.skipTag);
    }

    private void executeJibPush(ServiceHub hub) throws MojoExecutionException {
        this.log.info("Pushing Container image with [[B]]JIB(Java Image Builder)[[B]] mode", new Object[0]);
        JibBuildService jibBuildService = new JibBuildService(hub, new MojoParameters(this.session, this.project, null, null, null, this.settings, this.sourceDirectory, this.outputDirectory, null), this.log);
        jibBuildService.push(this.getResolvedImages(), this.retries, this.getRegistryConfig(this.pushRegistry), this.skipTag);
    }
}

