/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.HealthCheckMode;
import java.io.Serializable;

public class HealthCheckConfiguration
implements Serializable {
    private HealthCheckMode mode = HealthCheckMode.cmd;
    private String interval;
    private String timeout;
    private String startPeriod;
    private Integer retries;
    private Arguments cmd;

    public String getInterval() {
        return this.prepareTimeValue(this.interval);
    }

    public String getTimeout() {
        return this.prepareTimeValue(this.timeout);
    }

    public String getStartPeriod() {
        return this.prepareTimeValue(this.startPeriod);
    }

    private String prepareTimeValue(String timeout) {
        if (timeout == null) {
            return null;
        }
        return timeout.matches("^\\d+$") ? timeout + "s" : timeout;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public HealthCheckMode getMode() {
        return this.mode;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void validate() throws IllegalArgumentException {
        if (this.mode == null) {
            throw new IllegalArgumentException("HealthCheck: mode must not be null");
        }
        switch (this.mode) {
            case none: {
                if (this.interval == null && this.timeout == null && this.startPeriod == null && this.retries == null && this.cmd == null) break;
                throw new IllegalArgumentException("HealthCheck: no parameters are allowed when the health check mode is set to 'none'");
            }
            case cmd: {
                if (this.cmd != null) break;
                throw new IllegalArgumentException("HealthCheck: the parameter 'cmd' is mandatory when the health check mode is set to 'cmd' (default)");
            }
        }
    }

    public static class Builder {
        private HealthCheckConfiguration config = new HealthCheckConfiguration();

        public Builder interval(String interval) {
            this.config.interval = interval;
            return this;
        }

        public Builder timeout(String timeout) {
            this.config.timeout = timeout;
            return this;
        }

        public Builder startPeriod(String startPeriod) {
            this.config.startPeriod = startPeriod;
            return this;
        }

        public Builder cmd(Arguments command) {
            if (command != null) {
                this.config.cmd = command;
            }
            return this;
        }

        public Builder retries(Integer retries) {
            this.config.retries = retries;
            return this;
        }

        public Builder mode(String mode) {
            return this.mode(mode != null ? HealthCheckMode.valueOf(mode) : (HealthCheckMode)null);
        }

        public Builder mode(HealthCheckMode mode) {
            this.config.mode = mode;
            return this;
        }

        public HealthCheckConfiguration build() {
            return this.config;
        }
    }
}

