/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;

public class ArchiveService {
    private final Logger log;
    private DockerAssemblyManager dockerAssemblyManager;

    public ArchiveService(DockerAssemblyManager dockerAssemblyManager, Logger log) {
        this.log = log;
        this.dockerAssemblyManager = dockerAssemblyManager;
    }

    public void extractDockerCopyArchive(File archiveFile, File destinationDirectory) throws MojoExecutionException {
        this.dockerAssemblyManager.extractDockerTarArchive(archiveFile, destinationDirectory);
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, MojoParameters params) throws MojoExecutionException {
        return this.createDockerBuildArchive(imageConfig, params, null);
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, MojoParameters params, ArchiverCustomizer customizer) throws MojoExecutionException {
        File ret = this.createArchive(imageConfig.getName(), imageConfig.getBuildConfiguration(), params, this.log, customizer);
        this.log.info("%s: Created docker source tar %s", imageConfig.getDescription(), ret);
        return ret;
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfig, String assemblyName, MojoParameters mojoParameters) throws MojoExecutionException {
        String name = imageConfig.getName();
        try {
            List<AssemblyConfiguration> assemblyConfigurations = imageConfig.getBuildConfiguration().getAssemblyConfigurations();
            AssemblyConfiguration assemblyConfig = assemblyConfigurations.stream().filter(a -> a.getName().equals(assemblyName)).findFirst().orElse(null);
            if (assemblyConfig == null) {
                throw new IllegalArgumentException(String.format("Provided assembly name \"%s\" does not match any configured assemblies.", assemblyName));
            }
            return this.dockerAssemblyManager.getAssemblyFiles(name, assemblyConfig, mojoParameters, this.log);
        }
        catch (InvalidAssemblerConfigurationException | ArchiveCreationException | AssemblyFormattingException e) {
            throw new MojoExecutionException("Cannot extract assembly files for image " + name + ": " + e, (Exception)e);
        }
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDir, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        return this.dockerAssemblyManager.createChangedFilesArchive(entries, assemblyDir, imageName, mojoParameters);
    }

    File createArchive(String imageName, BuildImageConfiguration buildConfig, MojoParameters params, Logger log) throws MojoExecutionException {
        return this.createArchive(imageName, buildConfig, params, log, null);
    }

    File createArchive(String imageName, BuildImageConfiguration buildConfig, MojoParameters params, Logger log, ArchiverCustomizer customizer) throws MojoExecutionException {
        return this.dockerAssemblyManager.createDockerTarArchive(imageName, params, buildConfig, log, customizer);
    }
}

