/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.BuildOptions;
import io.fabric8.maven.docker.access.ContainerCreateConfig;
import io.fabric8.maven.docker.access.CreateImageOptions;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.NetworkCreateConfig;
import io.fabric8.maven.docker.access.UrlBuilder;
import io.fabric8.maven.docker.access.VolumeCreateConfig;
import io.fabric8.maven.docker.access.chunked.BuildJsonResponseHandler;
import io.fabric8.maven.docker.access.chunked.PullOrPushResponseJsonHandler;
import io.fabric8.maven.docker.access.hc.ApacheHttpClientDelegate;
import io.fabric8.maven.docker.access.hc.HcChunkedResponseHandlerWrapper;
import io.fabric8.maven.docker.access.hc.http.HttpClientBuilder;
import io.fabric8.maven.docker.access.hc.unix.UnixSocketClientBuilder;
import io.fabric8.maven.docker.access.hc.util.ClientBuilder;
import io.fabric8.maven.docker.access.hc.win.NamedPipeClientBuilder;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.access.log.LogRequestor;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.log.DefaultLogCallback;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.ContainerDetails;
import io.fabric8.maven.docker.model.ContainersListElement;
import io.fabric8.maven.docker.model.ExecDetails;
import io.fabric8.maven.docker.model.Image;
import io.fabric8.maven.docker.model.ImageDetails;
import io.fabric8.maven.docker.model.Network;
import io.fabric8.maven.docker.model.NetworksListElement;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.JsonFactory;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.TimestampFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;

public class DockerAccessWithHcClient
implements DockerAccess {
    private static final String UNIX_URL = "unix://127.0.0.1:1/";
    private static final String NPIPE_URL = "npipe://127.0.0.1:1/";
    public static final String API_VERSION = "1.18";
    private static final int COPY_BUFFER_SIZE = 65536;
    private static final String API_LOG_FORMAT_GET = "GET %s";
    private static final String API_LOG_FORMAT_POST = "POST %s";
    private static final String API_LOG_FORMAT_DELETE = "DELETE %s";
    private static final String API_LOG_FORMAT_POST_WITH_REQUEST = "POST to %s with %s";
    private static final String API_LOG_FORMAT_POST_FILE = "POST to %s with contents of file %s";
    private static final String API_LOG_FORMAT_PUT_FILE = "PUT to %s with contents of file %s";
    private final Logger log;
    private final ApacheHttpClientDelegate delegate;
    private final String apiVersion;
    private final String nativePlatform;
    private final UrlBuilder urlBuilder;

    public DockerAccessWithHcClient(@Nonnull String baseUrl, String certPath, int maxConnections, Logger log) throws IOException {
        URI uri = URI.create(baseUrl);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The docker access url '" + baseUrl + "' must contain a schema tcp://, unix:// or npipe://");
        }
        if (uri.getScheme().equalsIgnoreCase("unix")) {
            this.delegate = this.createHttpClient(new UnixSocketClientBuilder(uri.getPath(), maxConnections, log));
            baseUrl = UNIX_URL;
        } else if (uri.getScheme().equalsIgnoreCase("npipe")) {
            this.delegate = this.createHttpClient(new NamedPipeClientBuilder(uri.getPath(), maxConnections, log), false);
            baseUrl = NPIPE_URL;
        } else {
            this.delegate = this.createHttpClient(new HttpClientBuilder(DockerAccessWithHcClient.isSSL(baseUrl) ? certPath : null, maxConnections));
        }
        baseUrl = DockerAccessWithHcClient.stripTrailingSlash(baseUrl);
        String url = baseUrl + "/version";
        log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        JsonObject info = JsonFactory.newJsonObject(this.delegate.get(url, 200));
        this.apiVersion = info.get("ApiVersion").getAsString();
        this.nativePlatform = info.get("Os").getAsString() + "/" + info.get("Arch").getAsString();
        this.urlBuilder = new UrlBuilder(baseUrl, "v" + this.apiVersion);
        this.log = log;
    }

    static String stripTrailingSlash(String url) {
        int last = url.length();
        while (url.charAt(last - 1) == '/') {
            --last;
        }
        return url.substring(0, last);
    }

    @Override
    public String getServerApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void startExecContainer(String containerId, LogOutputSpec outputSpec) throws DockerAccessException {
        String url = this.urlBuilder.startExecContainer(containerId);
        JsonObject request = new JsonObject();
        request.addProperty("Detach", Boolean.valueOf(false));
        request.addProperty("Tty", Boolean.valueOf(true));
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_WITH_REQUEST, url, request);
        try {
            this.delegate.post(url, (Object)request.toString(), this.createExecResponseHandler(outputSpec), 200);
        }
        catch (Exception e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    private ResponseHandler<Object> createExecResponseHandler(LogOutputSpec outputSpec) throws FileNotFoundException {
        final DefaultLogCallback callback = new DefaultLogCallback(outputSpec);
        return new ResponseHandler<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object handleResponse(HttpResponse response) throws IOException {
                try (InputStream stream = response.getEntity().getContent();){
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
                    try {
                        String line;
                        callback.open();
                        while ((line = reader.readLine()) != null) {
                            callback.log(1, TimestampFactory.createTimestamp(), line);
                        }
                        callback.close();
                        return null;
                    }
                    catch (LogCallback.DoneException doneException) {
                        return null;
                    }
                    finally {
                        callback.close();
                    }
                }
            }
        };
    }

    @Override
    public String createExecContainer(String containerId, Arguments arguments) throws DockerAccessException {
        String url = this.urlBuilder.createExecContainer(containerId);
        JsonObject request = new JsonObject();
        request.addProperty("Tty", Boolean.valueOf(true));
        request.addProperty("AttachStdin", Boolean.valueOf(false));
        request.addProperty("AttachStdout", Boolean.valueOf(true));
        request.addProperty("AttachStderr", Boolean.valueOf(true));
        request.add("Cmd", (JsonElement)JsonFactory.newJsonArray(arguments.getExec()));
        String execJsonRequest = request.toString();
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_WITH_REQUEST, url, execJsonRequest);
        try {
            String response = this.delegate.post(url, (Object)execJsonRequest, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject(response);
            if (json.has("Warnings")) {
                this.logWarnings(json);
            }
            return json.get("Id").getAsString();
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to exec [%s] on container [%s]", request.toString(), containerId);
        }
    }

    @Override
    public String createContainer(ContainerCreateConfig containerConfig, String containerName) throws DockerAccessException {
        String createJson = containerConfig.toJson();
        String url = this.urlBuilder.createContainer(containerName);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_WITH_REQUEST, url, createJson);
        try {
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject(response);
            this.logWarnings(json);
            return json.get("Id").getAsString().substring(0, 12);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create container for [%s]", containerConfig.getImageName());
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerAccessException {
        String url = this.urlBuilder.startContainer(containerId);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, url);
        try {
            this.delegate.post(url, 204, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    @Override
    public void stopContainer(String containerId, int killWait) throws DockerAccessException {
        String url = this.urlBuilder.stopContainer(containerId, killWait);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, url);
        try {
            this.delegate.post(url, 204, 304);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to stop container id [%s]", containerId);
        }
    }

    @Override
    public void killContainer(String containerId) throws DockerAccessException {
        String url = this.urlBuilder.killContainer(containerId);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, url);
        try {
            this.delegate.post(url, 204, 304);
        }
        catch (IOException ie) {
            throw new DockerAccessException(ie, "Unable to kill container id [%s]", containerId);
        }
    }

    @Override
    public void buildImage(String image, File dockerArchive, BuildOptions options) throws DockerAccessException {
        String url = this.urlBuilder.buildImage(image, options);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_FILE, url, dockerArchive);
        try {
            this.delegate.post(url, (Object)dockerArchive, this.createBuildResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to build image [%s]", image);
        }
    }

    @Override
    public void copyArchiveToContainer(String containerId, File archive, String targetPath) throws DockerAccessException {
        String url = this.urlBuilder.copyArchive(containerId, targetPath);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_PUT_FILE, url, archive);
        try {
            this.delegate.put(url, archive, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to copy archive %s to container [%s] with path %s", archive.toPath(), containerId, targetPath);
        }
    }

    @Override
    public void copyArchiveFromContainer(String containerId, String containerPath, File archive) throws DockerAccessException {
        String url = this.urlBuilder.copyArchive(containerId, containerPath);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            this.delegate.get(url, this.getContainerFileHandler(archive), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to copy archived path %s from container [%s] into file %s", containerPath, containerId, archive.toPath());
        }
    }

    private ResponseHandler<Object> getContainerFileHandler(final File file) {
        return new ResponseHandler<Object>(){

            public Object handleResponse(HttpResponse response) throws IOException {
                try (InputStream stream = response.getEntity().getContent();
                     FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)stream, (OutputStream)out, (int)65536);
                }
                return null;
            }
        };
    }

    @Override
    public void getLogSync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor(this.delegate.getHttpClient(), this.urlBuilder, containerId, callback);
        extractor.fetchLogs();
    }

    @Override
    public LogGetHandle getLogAsync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor(this.delegate.createBasicClient(), this.urlBuilder, containerId, callback);
        extractor.start();
        return extractor;
    }

    @Override
    public List<Container> getContainersForImage(String image, boolean all) throws DockerAccessException {
        String serverApiVersion = this.getServerApiVersion();
        String url = EnvUtil.greaterOrEqualsVersion(serverApiVersion, "1.23") ? this.urlBuilder.listContainers(all, "ancestor", image) : this.urlBuilder.listContainers(all, new String[0]);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray(response);
            ArrayList<Container> containers = new ArrayList<Container>();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject element = array.get(i).getAsJsonObject();
                if (!image.equals(element.get("Image").getAsString())) continue;
                containers.add(new ContainersListElement(element));
            }
            return containers;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public List<Container> listContainers(boolean all) throws DockerAccessException {
        String url = this.urlBuilder.listContainers(all, new String[0]);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray(response);
            ArrayList<Container> containers = new ArrayList<Container>();
            for (JsonElement element : array) {
                containers.add(new ContainersListElement(element.getAsJsonObject()));
            }
            return containers;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public ContainerDetails getContainer(String containerIdOrName) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectContainer(containerIdOrName);
        if (response.getStatusCode() == 404) {
            return null;
        }
        return new ContainerDetails(JsonFactory.newJsonObject(response.getBody()));
    }

    @Override
    public ExecDetails getExecContainer(String containerIdOrName) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectExecContainer(containerIdOrName);
        if (response.getStatusCode() == 404) {
            return null;
        }
        return new ExecDetails(JsonFactory.newJsonObject(response.getBody()));
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectContainer(String containerIdOrName) throws DockerAccessException {
        String url = this.urlBuilder.inspectContainer(containerIdOrName);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to retrieve container name for [%s]", containerIdOrName);
        }
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectExecContainer(String containerIdOrName) throws DockerAccessException {
        String url = this.urlBuilder.inspectExecContainer(containerIdOrName);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to retrieve container name for [%s]", containerIdOrName);
        }
    }

    @Override
    public List<Image> listImages(boolean all) throws DockerAccessException {
        String url = this.urlBuilder.listImages(all);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray(response);
            ArrayList<Image> images = new ArrayList<Image>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                images.add(new ImageDetails(array.get(i).getAsJsonObject()));
            }
            return images;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public boolean hasImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.StatusCodeResponseHandler(), 200, 404) == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to check image [%s]", name);
        }
    }

    @Override
    public String getImageId(String name) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectImage(name);
        if (response.getStatusCode() == 404) {
            return null;
        }
        JsonObject imageDetails = JsonFactory.newJsonObject(response.getBody());
        return imageDetails.get("Id").getAsString().substring(0, 12);
    }

    @Override
    public List<String> getImageTags(String name) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectImage(name);
        if (response.getStatusCode() == 404) {
            return null;
        }
        JsonObject imageDetails = JsonFactory.newJsonObject(response.getBody());
        JsonArray tagsArr = imageDetails.get("RepoTags").getAsJsonArray();
        if (tagsArr.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>();
        tagsArr.forEach(tag -> tags.add(tag.getAsString()));
        return tags;
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to inspect image [%s]", name);
        }
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerAccessException {
        String url = this.urlBuilder.removeContainer(containerId, removeVolumes);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_DELETE, url);
        try {
            this.delegate.delete(url, 204);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove container [%s]", containerId);
        }
    }

    @Override
    public void loadImage(String image, File tarArchive) throws DockerAccessException {
        String url = this.urlBuilder.loadImage();
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_FILE, url, tarArchive);
        try {
            this.delegate.post(url, (Object)tarArchive, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to load %s", tarArchive);
        }
    }

    @Override
    public void pullImage(String image, AuthConfig authConfig, String registry, CreateImageOptions options) throws DockerAccessException {
        String pullUrl = this.urlBuilder.pullImage(options);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, pullUrl);
        try {
            this.delegate.post(pullUrl, null, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to pull '%s'%s", image, registry != null ? " from registry '" + registry + "'" : "");
        }
    }

    @Override
    public void pushImage(String image, AuthConfig authConfig, String registry, int retries) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String pushUrl = this.urlBuilder.pushImage(name, registry);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, pushUrl);
        TemporaryImageHandler temporaryImageHandler = this.tagTemporaryImage(name, registry);
        DockerAccessException dae = null;
        try {
            this.doPushImage(pushUrl, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200, retries);
        }
        catch (IOException e) {
            dae = new DockerAccessException(e, "Unable to push '%s'%s", image, registry != null ? " to registry '" + registry + "'" : "");
            throw dae;
        }
        finally {
            temporaryImageHandler.handle(dae);
        }
    }

    @Override
    public void saveImage(String image, String filename, ArchiveCompression compression) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String url = this.urlBuilder.getImage(name);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            this.delegate.get(url, this.getImageResponseHandler(filename, compression), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to save '%s' to '%s'", image, filename);
        }
    }

    private ResponseHandler<Object> getImageResponseHandler(final String filename, final ArchiveCompression compression) throws FileNotFoundException {
        return new ResponseHandler<Object>(){

            public Object handleResponse(HttpResponse response) throws IOException {
                try (InputStream stream = response.getEntity().getContent();
                     OutputStream out = compression.wrapOutputStream(new FileOutputStream(filename));){
                    IOUtils.copy((InputStream)stream, (OutputStream)out, (int)65536);
                }
                return null;
            }
        };
    }

    @Override
    public void tag(String sourceImage, String targetImage, boolean force) throws DockerAccessException {
        ImageName source = new ImageName(sourceImage);
        ImageName target = new ImageName(targetImage);
        String url = this.urlBuilder.tagContainer(source, target, force);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST, url);
        try {
            this.delegate.post(url, 201);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to add tag [%s] to image [%s]", targetImage, sourceImage, e);
        }
    }

    @Override
    public boolean removeImage(String image, boolean force) throws DockerAccessException {
        String url = this.urlBuilder.deleteImage(image, force);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_DELETE, url);
        try {
            ApacheHttpClientDelegate.HttpBodyAndStatus response = this.delegate.delete(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
            if (this.log.isDebugEnabled()) {
                this.logRemoveResponse(JsonFactory.newJsonArray(response.getBody()));
            }
            return response.getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove image [%s]", image);
        }
    }

    @Override
    public List<Network> listNetworks() throws DockerAccessException {
        String url = this.urlBuilder.listNetworks();
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_GET, url);
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray(response);
            ArrayList<Network> networks = new ArrayList<Network>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                networks.add(new NetworksListElement(array.get(i).getAsJsonObject()));
            }
            return networks;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public String createNetwork(NetworkCreateConfig networkConfig) throws DockerAccessException {
        String createJson = networkConfig.toJson();
        this.log.debug("Network create config: " + createJson, new Object[0]);
        String url = this.urlBuilder.createNetwork();
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_WITH_REQUEST, url, createJson);
        try {
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            this.log.debug(response, new Object[0]);
            JsonObject json = JsonFactory.newJsonObject(response);
            if (json.has("Warnings")) {
                this.logWarnings(json);
            }
            return json.get("Id").getAsString().substring(0, 12);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create network for [%s]", networkConfig.getName());
        }
    }

    @Override
    public boolean removeNetwork(String networkId) throws DockerAccessException {
        String url = this.urlBuilder.removeNetwork(networkId);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_DELETE, url);
        try {
            int status = this.delegate.delete(url, 200, 204, 404);
            return status == 200 || status == 204;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove network [%s]", networkId);
        }
    }

    @Override
    public String createVolume(VolumeCreateConfig containerConfig) throws DockerAccessException {
        String createJson = containerConfig.toJson();
        this.log.debug("Volume create config: %s", createJson);
        String url = this.urlBuilder.createVolume();
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_POST_WITH_REQUEST, url, createJson);
        try {
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject(response);
            this.logWarnings(json);
            return json.get("Name").getAsString();
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create volume for [%s]", containerConfig.getName());
        }
    }

    @Override
    public void removeVolume(String name) throws DockerAccessException {
        String url = this.urlBuilder.removeVolume(name);
        this.log.verbose(Logger.LogVerboseCategory.API, API_LOG_FORMAT_DELETE, url);
        try {
            this.delegate.delete(url, 204, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove volume [%s]", name);
        }
    }

    @Override
    public String getNativePlatform() {
        return this.nativePlatform;
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
        try {
            this.delegate.close();
        }
        catch (IOException exp) {
            this.log.error("Error while closing HTTP client: " + exp, exp);
        }
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder) throws IOException {
        return this.createHttpClient(builder, true);
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder, boolean pooled) throws IOException {
        return new ApacheHttpClientDelegate(builder, pooled);
    }

    private HcChunkedResponseHandlerWrapper createBuildResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new BuildJsonResponseHandler(this.log));
    }

    private HcChunkedResponseHandlerWrapper createPullOrPushResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new PullOrPushResponseJsonHandler(this.log));
    }

    private Map<String, String> createAuthHeader(AuthConfig authConfig) {
        if (authConfig == null) {
            authConfig = AuthConfig.EMPTY_AUTH_CONFIG;
        }
        return Collections.singletonMap("X-Registry-Auth", authConfig.toHeaderValue());
    }

    private boolean isRetryableErrorCode(int errorCode) {
        return errorCode == 500;
    }

    private void doPushImage(String url, Map<String, String> header, HcChunkedResponseHandlerWrapper handler, int status, int retries) throws IOException {
        for (int i = 0; i <= retries; ++i) {
            try {
                this.delegate.post(url, null, header, handler, 200);
                return;
            }
            catch (HttpResponseException e) {
                if (!this.isRetryableErrorCode(e.getStatusCode()) || i == retries) {
                    throw e;
                }
                this.log.warn("failed to push image to [{}], retrying...", url);
                continue;
            }
        }
    }

    private TemporaryImageHandler tagTemporaryImage(ImageName name, String registry) throws DockerAccessException {
        String targetImage = name.getFullName(registry);
        if (name.hasRegistry() || registry == null) {
            return () -> this.log.info("Temporary image tag skipped. Target image '%s' already has registry set or no registry is available", targetImage);
        }
        String fullName = name.getFullName();
        boolean alreadyHasImage = this.hasImage(targetImage);
        if (alreadyHasImage) {
            this.log.warn("Target image '%s' already exists. Tagging of '%s' will replace existing image", targetImage, fullName);
        }
        this.tag(fullName, targetImage, false);
        return alreadyHasImage ? () -> this.log.info("Tagged image '%s' won't be removed after tagging as it already existed", targetImage) : new RemovingTemporaryImageHandler(targetImage);
    }

    private void logWarnings(JsonObject body) {
        JsonElement warningsObj;
        if (body.has("Warnings") && !(warningsObj = body.get("Warnings")).isJsonNull()) {
            JsonArray warnings = (JsonArray)warningsObj;
            for (int i = 0; i < warnings.size(); ++i) {
                this.log.warn(warnings.get(i).getAsString(), new Object[0]);
            }
        }
    }

    private void logRemoveResponse(JsonArray logElements) {
        for (int i = 0; i < logElements.size(); ++i) {
            JsonObject entry = logElements.get(i).getAsJsonObject();
            for (Object key : entry.keySet()) {
                this.log.debug("%s: %s", key, entry.get(key.toString()));
            }
        }
    }

    private static boolean isSSL(String url) {
        return url.toLowerCase().startsWith("https");
    }

    private final class RemovingTemporaryImageHandler
    implements TemporaryImageHandler {
        private final String targetImage;

        private RemovingTemporaryImageHandler(String targetImage) {
            this.targetImage = targetImage;
        }

        @Override
        public void handle() throws DockerAccessException {
            boolean imageRemoved = DockerAccessWithHcClient.this.removeImage(this.targetImage, true);
            if (imageRemoved) {
                return;
            }
            throw new DockerAccessException("Image %s could be pushed, but the temporary tag could not be removed", this.targetImage);
        }
    }

    @FunctionalInterface
    private static interface TemporaryImageHandler {
        public void handle() throws DockerAccessException;

        default public void handle(@Nullable DockerAccessException interruptingError) throws DockerAccessException {
            this.handle();
            if (interruptingError == null) {
                return;
            }
            throw interruptingError;
        }
    }
}

