/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.CleanupMode;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.HealthCheckConfiguration;
import io.fabric8.maven.docker.util.DeepCopy;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.Parameter;

public class BuildImageConfiguration
implements Serializable {
    public static final String DEFAULT_FILTER = "${*}";
    public static final String DEFAULT_CLEANUP = "try";
    @Parameter
    private String contextDir;
    @Deprecated
    @Parameter
    private String dockerFileDir;
    @Parameter
    private String dockerFile;
    @Parameter
    private String dockerArchive;
    @Parameter
    private String loadNamePattern;
    @Parameter
    private String filter;
    @Parameter
    private String from;
    @Parameter
    private Map<String, String> fromExt;
    @Parameter
    private List<String> cacheFrom;
    @Parameter
    private String registry;
    @Parameter
    private String maintainer;
    @Parameter
    private String network;
    @Parameter
    private List<String> ports;
    @Parameter
    private String imagePullPolicy;
    @Parameter
    private Arguments shell;
    @Parameter
    private List<String> runCmds;
    @Parameter
    private String cleanup;
    @Deprecated
    @Parameter
    private Boolean nocache;
    @Parameter
    private Boolean noCache;
    @Parameter
    private Boolean squash;
    @Parameter
    private Boolean optimise;
    @Parameter
    private List<String> volumes;
    @Parameter
    private List<String> tags;
    @Parameter
    private Map<String, String> env;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private Map<String, String> args;
    @Parameter
    private Arguments entryPoint;
    @Deprecated
    @Parameter
    private String command;
    @Parameter
    private String workdir;
    @Parameter
    private Arguments cmd;
    @Parameter
    private String user;
    @Parameter
    private HealthCheckConfiguration healthCheck;
    @Parameter
    private AssemblyConfiguration assembly;
    @Parameter
    private List<AssemblyConfiguration> assemblies;
    @Parameter
    private Boolean skip;
    @Parameter
    private Boolean skipPush;
    @Parameter
    private ArchiveCompression compression = ArchiveCompression.none;
    @Parameter
    private Map<String, String> buildOptions;
    private File dockerFileFile;
    private File dockerArchiveFile;

    public boolean isDockerFileMode() {
        return this.dockerFileFile != null;
    }

    public String getLoadNamePattern() {
        return this.loadNamePattern;
    }

    public File getContextDir() {
        if (!this.isDockerFileMode()) {
            return null;
        }
        if (this.contextDir != null) {
            return new File(this.contextDir);
        }
        if (this.getDockerFile().getParentFile() == null) {
            return new File("");
        }
        return this.getDockerFile().getParentFile();
    }

    public String getContextDirRaw() {
        return this.contextDir;
    }

    public File getDockerFile() {
        return this.dockerFileFile;
    }

    public File getDockerArchive() {
        return this.dockerArchiveFile;
    }

    public String getDockerFileRaw() {
        return this.dockerFile;
    }

    public String getDockerArchiveRaw() {
        return this.dockerArchive;
    }

    public String getDockerFileDirRaw() {
        return this.dockerFileDir;
    }

    public String getFilter() {
        return this.filter != null ? this.filter : DEFAULT_FILTER;
    }

    public String getFilterRaw() {
        return this.filter;
    }

    public String getFrom() {
        if (this.from == null && this.getFromExt() != null) {
            return this.getFromExt().get("name");
        }
        return this.from;
    }

    public Map<String, String> getFromExt() {
        return this.fromExt;
    }

    public List<String> getCacheFrom() {
        return this.cacheFrom;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    @Deprecated
    public AssemblyConfiguration getAssemblyConfiguration() {
        return this.assembly;
    }

    @Nonnull
    public List<AssemblyConfiguration> getAssemblyConfigurations() {
        ArrayList<AssemblyConfiguration> assemblyConfigurations = new ArrayList<AssemblyConfiguration>();
        if (this.assemblies != null) {
            for (AssemblyConfiguration config : this.assemblies) {
                if (config == null) continue;
                assemblyConfigurations.add(config);
            }
        }
        if (this.assembly != null) {
            assemblyConfigurations.add(this.assembly);
        }
        return assemblyConfigurations;
    }

    @Nonnull
    public List<String> getPorts() {
        return EnvUtil.removeEmptyEntries(this.ports);
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Nonnull
    public List<String> getVolumes() {
        return EnvUtil.removeEmptyEntries(this.volumes);
    }

    @Nonnull
    public List<String> getTags() {
        return EnvUtil.removeEmptyEntries(this.tags);
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    @Deprecated
    public String getCommand() {
        return this.command;
    }

    public String getCleanup() {
        return this.cleanup;
    }

    public CleanupMode cleanupMode() {
        return CleanupMode.parse(this.cleanup != null ? this.cleanup : DEFAULT_CLEANUP);
    }

    public boolean noCache() {
        if (this.noCache != null) {
            return this.noCache;
        }
        if (this.nocache != null) {
            return this.nocache;
        }
        return false;
    }

    public boolean squash() {
        if (this.squash != null) {
            return this.squash;
        }
        return false;
    }

    public boolean optimise() {
        return this.optimise != null ? this.optimise : false;
    }

    public boolean skip() {
        return this.skip != null ? this.skip : false;
    }

    public boolean skipPush() {
        return this.skipPush != null ? this.skipPush : false;
    }

    public Boolean getNoCache() {
        return this.noCache != null ? this.noCache : this.nocache;
    }

    public Boolean getSquash() {
        return this.squash != null ? this.squash : false;
    }

    public Boolean getOptimise() {
        return this.optimise;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public Boolean getSkipPush() {
        return this.skipPush;
    }

    public ArchiveCompression getCompression() {
        return this.compression;
    }

    public Map<String, String> getBuildOptions() {
        return this.buildOptions;
    }

    public Arguments getEntryPoint() {
        return this.entryPoint;
    }

    public Arguments getShell() {
        return this.shell;
    }

    @Nonnull
    public List<String> getRunCmds() {
        return EnvUtil.removeEmptyEntries(this.runCmds);
    }

    public String getUser() {
        return this.user;
    }

    public HealthCheckConfiguration getHealthCheck() {
        return this.healthCheck;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public File getAbsoluteContextDirPath(MojoParameters mojoParams) {
        return EnvUtil.prepareAbsoluteSourceDirPath(mojoParams, this.getContextDir().getPath());
    }

    public File getAbsoluteDockerFilePath(MojoParameters mojoParams) {
        return EnvUtil.prepareAbsoluteSourceDirPath(mojoParams, this.getDockerFile().getPath());
    }

    public File getAbsoluteDockerTarPath(MojoParameters mojoParams) {
        return EnvUtil.prepareAbsoluteSourceDirPath(mojoParams, this.getDockerArchive().getPath());
    }

    public void initTags(ConfigHelper.NameFormatter nameFormatter) {
        if (this.tags != null) {
            this.tags = this.tags.stream().map(nameFormatter::format).collect(Collectors.toList());
        }
    }

    public String initAndValidate(Logger log) throws IllegalArgumentException {
        if (this.entryPoint != null) {
            this.entryPoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if (this.healthCheck != null) {
            this.healthCheck.validate();
        }
        this.ensureUniqueAssemblyNames(log);
        if (this.command != null) {
            log.warn("<command> in the <build> configuration is deprecated and will be be removed soon", new Object[0]);
            log.warn("Please use <cmd> with nested <shell> or <exec> sections instead.", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("More on this is explained in the user manual: ", new Object[0]);
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/manual.md#start-up-arguments", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("Migration is trivial, see changelog to version 0.12.0 -->", new Object[0]);
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/changelog.md", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("For now, the command is automatically translated for you to the shell form:", new Object[0]);
            log.warn("   <cmd>%s</cmd>", this.command);
        }
        this.initDockerFileFile(log);
        if (this.cacheFrom != null && !this.cacheFrom.isEmpty()) {
            return "1.25";
        }
        if (this.healthCheck != null) {
            return "1.24";
        }
        if (this.args != null) {
            return "1.21";
        }
        return null;
    }

    private void ensureUniqueAssemblyNames(Logger log) {
        List<AssemblyConfiguration> assemblyConfigurations = this.getAssemblyConfigurations();
        HashSet<String> assemblyNames = new HashSet<String>();
        for (AssemblyConfiguration config : assemblyConfigurations) {
            String assemblyName = config.getName();
            boolean wasElementAbsent = assemblyNames.add(assemblyName);
            if (wasElementAbsent) continue;
            log.error("Multiple assemblies use the name \"%s\". Please assign each assembly a unique name.", assemblyName);
            throw new IllegalArgumentException("Assembly names must be unique");
        }
    }

    private void initDockerFileFile(Logger log) {
        if ((this.dockerFile != null || this.dockerFileDir != null) && this.dockerArchive != null) {
            throw new IllegalArgumentException("Both <dockerFile> (<dockerFileDir>) and <dockerArchive> are set. Only one of them can be specified.");
        }
        this.dockerFileFile = this.findDockerFileFile(log);
        if (this.dockerArchive != null) {
            this.dockerArchiveFile = new File(this.dockerArchive);
        }
    }

    private File findDockerFileFile(Logger log) {
        Optional<String> deprecatedDockerFileDir;
        if (this.dockerFileDir != null && this.contextDir != null) {
            log.warn("Both contextDir (%s) and deprecated dockerFileDir (%s) are configured. Using contextDir.", this.contextDir, this.dockerFileDir);
        }
        if (this.dockerFile != null) {
            File dFile = new File(this.dockerFile);
            if (this.dockerFileDir == null && this.contextDir == null) {
                return dFile;
            }
            if (this.contextDir != null) {
                if (dFile.isAbsolute()) {
                    return dFile;
                }
                return new File(this.contextDir, this.dockerFile);
            }
            if (this.dockerFileDir != null) {
                if (dFile.isAbsolute()) {
                    throw new IllegalArgumentException("<dockerFile> can not be absolute path if <dockerFileDir> also set.");
                }
                log.warn("dockerFileDir parameter is deprecated, please migrate to contextDir", new Object[0]);
                return new File(this.dockerFileDir, this.dockerFile);
            }
        }
        if (this.contextDir != null) {
            return new File(this.contextDir, "Dockerfile");
        }
        if (this.dockerFileDir != null) {
            return new File(this.dockerFileDir, "Dockerfile");
        }
        if (this.dockerArchive == null && (deprecatedDockerFileDir = this.getAssemblyConfigurations().stream().map(AssemblyConfiguration::getDockerFileDir).filter(Objects::nonNull).findFirst()).isPresent()) {
            log.warn("<dockerFileDir> in the <assembly> section of a <build> configuration is deprecated", new Object[0]);
            log.warn("Please use <dockerFileDir> or <dockerFile> directly within the <build> configuration instead", new Object[0]);
            return new File(deprecatedDockerFileDir.get(), "Dockerfile");
        }
        return null;
    }

    public static class Builder {
        private final BuildImageConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(BuildImageConfiguration that) {
            this.config = that == null ? new BuildImageConfiguration() : DeepCopy.copy(that);
        }

        public Builder contextDir(String dir) {
            this.config.contextDir = dir;
            return this;
        }

        public Builder dockerFileDir(String dir) {
            this.config.dockerFileDir = dir;
            return this;
        }

        public Builder dockerFile(String file) {
            this.config.dockerFile = file;
            return this;
        }

        public Builder dockerArchive(String archive) {
            this.config.dockerArchive = archive;
            return this;
        }

        public Builder loadNamePattern(String archiveEntryRepoTagPattern) {
            this.config.loadNamePattern = archiveEntryRepoTagPattern;
            return this;
        }

        public Builder filter(String filter) {
            this.config.filter = filter;
            return this;
        }

        public Builder from(String from) {
            this.config.from = from;
            return this;
        }

        public Builder fromExt(Map<String, String> fromExt) {
            this.config.fromExt = fromExt;
            return this;
        }

        public Builder cacheFrom(String cacheFrom, String ... more) {
            if (more == null || more.length == 0) {
                return this.cacheFrom(Collections.singletonList(cacheFrom));
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(cacheFrom);
            list.addAll(Arrays.asList(more));
            return this.cacheFrom(list);
        }

        public Builder cacheFrom(Collection<String> cacheFrom) {
            this.config.cacheFrom = cacheFrom != null ? new ArrayList<String>(cacheFrom) : null;
            return this;
        }

        public Builder registry(String registry) {
            this.config.registry = registry;
            return this;
        }

        public Builder maintainer(String maintainer) {
            this.config.maintainer = maintainer;
            return this;
        }

        public Builder network(String network) {
            this.config.network = network;
            return this;
        }

        public Builder workdir(String workdir) {
            this.config.workdir = workdir;
            return this;
        }

        public Builder assembly(AssemblyConfiguration assembly) {
            this.config.assembly = assembly;
            return this;
        }

        public Builder assemblies(List<AssemblyConfiguration> assemblies) {
            this.config.assemblies = assemblies;
            return this;
        }

        public Builder ports(List<String> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder imagePullPolicy(String imagePullPolicy) {
            this.config.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public Builder shell(Arguments shell) {
            if (shell != null) {
                this.config.shell = shell;
            }
            return this;
        }

        public Builder runCmds(List<String> theCmds) {
            if (theCmds == null) {
                this.config.runCmds = new ArrayList();
            } else {
                this.config.runCmds = theCmds;
            }
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.config.tags = tags;
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder args(Map<String, String> args) {
            this.config.args = args;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public Builder cmd(Arguments cmd) {
            if (cmd != null) {
                this.config.cmd = cmd;
            }
            return this;
        }

        public Builder cleanup(String cleanup) {
            this.config.cleanup = cleanup;
            return this;
        }

        public Builder compression(String compression) {
            if (compression == null) {
                this.config.compression = ArchiveCompression.none;
            } else {
                this.config.compression = ArchiveCompression.valueOf(compression);
            }
            return this;
        }

        public Builder noCache(Boolean noCache) {
            this.config.noCache = noCache;
            return this;
        }

        public Builder squash(Boolean squash) {
            this.config.squash = squash;
            return this;
        }

        public Builder optimise(Boolean optimise) {
            this.config.optimise = optimise;
            return this;
        }

        public Builder entryPoint(Arguments entryPoint) {
            if (entryPoint != null) {
                this.config.entryPoint = entryPoint;
            }
            return this;
        }

        public Builder user(String user) {
            this.config.user = user;
            return this;
        }

        public Builder healthCheck(HealthCheckConfiguration healthCheck) {
            this.config.healthCheck = healthCheck;
            return this;
        }

        public Builder skip(Boolean skip) {
            this.config.skip = skip;
            return this;
        }

        public Builder skipPush(Boolean skipPush) {
            this.config.skipPush = skipPush;
            return this;
        }

        public Builder buildOptions(Map<String, String> buildOptions) {
            this.config.buildOptions = buildOptions;
            return this;
        }

        public BuildImageConfiguration build() {
            return this.config;
        }
    }
}

