/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.assembly.DockerAssemblyConfigurationSource;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugins.assembly.io.DefaultAssemblyReader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.yaml.snakeyaml.Yaml;

public class DockerFileUtil {
    private DockerFileUtil() {
    }

    public static List<String> extractBaseImages(File dockerFile, FixedStringSearchInterpolator interpolator) throws IOException {
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", interpolator);
        LinkedList<String> result = new LinkedList<String>();
        for (String[] fromLine : fromLines) {
            if (fromLine.length <= 1) continue;
            result.add(fromLine[1]);
        }
        return result;
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, FixedStringSearchInterpolator interpolator) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = interpolator.interpolate(line);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, FixedStringSearchInterpolator interpolator) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(interpolator.interpolate(line)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    public static FixedStringSearchInterpolator createInterpolator(MojoParameters params, String filter) {
        String[] delimiters = DockerFileUtil.extractDelimiters(filter);
        if (delimiters == null) {
            return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[0]);
        }
        DockerAssemblyConfigurationSource configSource = new DockerAssemblyConfigurationSource(params, null, null);
        return AssemblyInterpolator.fullInterpolator((MavenProject)params.getProject(), (FixedStringSearchInterpolator)DefaultAssemblyReader.createProjectInterpolator((MavenProject)params.getProject()).withExpressionMarkers(delimiters[0], delimiters[1]), (AssemblerConfigurationSource)configSource).withExpressionMarkers(delimiters[0], delimiters[1]);
    }

    private static Reader getFileReaderFromDir(File file) {
        if (file.exists() && file.length() != 0L) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find " + file, e);
            }
        }
        return null;
    }

    public static JsonObject readDockerConfig() {
        String dockerConfig = System.getenv("DOCKER_CONFIG");
        Reader reader = dockerConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".docker/config.json")) : DockerFileUtil.getFileReaderFromDir(new File(dockerConfig, "config.json"));
        return reader != null ? (JsonObject)new Gson().fromJson(reader, JsonObject.class) : null;
    }

    public static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return null;
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }

    public static Map<String, ?> readKubeConfig() {
        Reader reader;
        String kubeConfig = System.getenv("KUBECONFIG");
        Reader reader2 = reader = kubeConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".kube/config")) : DockerFileUtil.getFileReaderFromDir(new File(kubeConfig));
        if (reader != null) {
            Yaml ret = new Yaml();
            return (Map)ret.load(reader);
        }
        return null;
    }

    private static File getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            homeDir = System.getenv("HOME");
        }
        return new File(homeDir);
    }
}

