/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.ExecException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.Network;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ContainerNamingUtil;
import io.fabric8.maven.docker.util.GavLabel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter(property="docker.allContainers", defaultValue="false")
    private boolean allContainers;
    @Parameter(property="docker.sledgeHammer", defaultValue="false")
    private boolean sledgeHammer;
    @Parameter(property="docker.containerNamePattern")
    private String containerNamePattern = "%n-%i";

    @Override
    protected void executeInternal(ServiceHub hub) throws MojoExecutionException, IOException, ExecException {
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        GavLabel gavLabel = this.getGavLabel();
        if (!this.keepRunning) {
            if (this.invokedTogetherWithDockerStart()) {
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, gavLabel);
            } else {
                this.stopContainers(queryService, runService, gavLabel);
            }
        }
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        dispatcher.untrackAllContainerLogs();
    }

    private void stopContainers(QueryService queryService, RunService runService, GavLabel gavLabel) throws IOException, ExecException {
        Set<Network> networksToRemove = this.getNetworksToRemove(queryService, gavLabel);
        for (ImageConfiguration image : this.getResolvedImages()) {
            Collection<Container> existingContainers = ContainerNamingUtil.getContainersToStop(image, this.containerNamePattern, this.getBuildTimestamp(), queryService.getContainersForImage(image.getName(), false));
            for (Container container : existingContainers) {
                if (!this.shouldStopContainer(container, gavLabel)) continue;
                runService.stopContainer(container.getId(), image, this.keepContainer, this.removeVolumes);
            }
        }
        runService.removeCustomNetworks(networksToRemove);
    }

    private boolean shouldStopContainer(Container container, GavLabel gavLabel) {
        if (this.isStopAllContainers()) {
            return true;
        }
        String key = gavLabel.getKey();
        Map<String, String> labels = container.getLabels();
        return labels.containsKey(key) && gavLabel.equals(new GavLabel(labels.get(key)));
    }

    private boolean isStopAllContainers() {
        return this.allContainers || this.sledgeHammer;
    }

    private boolean invokedTogetherWithDockerStart() {
        Boolean startCalled = (Boolean)this.getPluginContext().get("CONTEXT_KEY_DOCKER_START_CALLED");
        return startCalled != null && startCalled != false;
    }

    private Set<Network> getNetworksToRemove(QueryService queryService, GavLabel gavLabel) throws IOException {
        if (!this.autoCreateCustomNetworks) {
            return Collections.emptySet();
        }
        HashSet<Network> customNetworks = new HashSet<Network>();
        Set<Network> networks = queryService.getNetworks();
        for (ImageConfiguration image : this.getResolvedImages()) {
            NetworkConfig config = image.getRunConfiguration().getNetworkingConfig();
            Network network = this.getNetworkByName(networks, config.getCustomNetwork());
            if (!config.isCustomNetwork() || network == null) continue;
            customNetworks.add(network);
            Collection<Container> existingContainers = ContainerNamingUtil.getContainersToStop(image, this.containerNamePattern, this.getBuildTimestamp(), queryService.getContainersForImage(image.getName(), false));
            for (Container container : existingContainers) {
                if (this.shouldStopContainer(container, gavLabel)) continue;
                customNetworks.remove(network);
            }
        }
        return customNetworks;
    }

    private Network getNetworkByName(Set<Network> networks, String networkName) {
        for (Network network : networks) {
            if (!networkName.equals(network.getName())) continue;
            return network;
        }
        return null;
    }
}

