/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import com.google.common.util.concurrent.MoreExecutors;
import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.ExecException;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.helper.StartContainerExecutor;
import io.fabric8.maven.docker.util.StartOrderResolver;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.showLogs")
    private String showLogs;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.skip.run", defaultValue="false")
    private boolean skipRun;
    @Parameter(property="docker.startParallel", defaultValue="false")
    private boolean startParallel;
    private boolean follow;
    @Parameter(property="docker.exposeContainerInfo")
    private String exposeContainerProps = "docker.container";
    @Parameter(property="docker.containerNamePattern")
    private String containerNamePattern = "%n-%i";
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter
    protected String portPropertyFile;

    @Override
    public synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, ExecException, MojoExecutionException {
        if (this.skipRun) {
            return;
        }
        this.getPluginContext().put("CONTEXT_KEY_DOCKER_START_CALLED", true);
        this.follow = this.followLogs();
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper = new PortMapping.PropertyWriteHelper(this.portPropertyFile);
        boolean success = false;
        ExecutorService executorService = this.getExecutorService();
        ExecutorCompletionService<StartedContainer> containerStartupService = new ExecutorCompletionService<StartedContainer>(executorService);
        try {
            HashSet<String> imageAliases = new HashSet<String>();
            HashSet<String> startedContainerAliases = new HashSet<String>();
            Queue<ImageConfiguration> imagesWaitingToStart = this.prepareStart(hub, queryService, runService, imageAliases);
            ArrayDeque<ImageConfiguration> imagesStarting = new ArrayDeque<ImageConfiguration>();
            if (this.follow) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks);
            }
            while (!this.hasBeenAllImagesStarted(imagesWaitingToStart, imagesStarting)) {
                List<ImageConfiguration> imagesReadyToStart = this.getImagesWhoseDependenciesHasStarted(imagesWaitingToStart, startedContainerAliases, imageAliases);
                for (ImageConfiguration image : imagesReadyToStart) {
                    this.startImage(image, hub, containerStartupService, portMappingPropertyWriteHelper);
                    imagesStarting.add(image);
                    imagesWaitingToStart.remove(image);
                    if (this.startParallel) continue;
                    this.waitForStartedContainer(hub, containerStartupService, startedContainerAliases, imagesStarting);
                }
                if (!this.startParallel) continue;
                this.waitForStartedContainer(hub, containerStartupService, startedContainerAliases, imagesStarting);
            }
            portMappingPropertyWriteHelper.write();
            if (this.follow) {
                this.wait();
            }
            success = true;
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
        finally {
            this.shutdownExecutorService(executorService);
            if (!success) {
                this.log.error("Error occurred during container startup, shutting down...", new Object[0]);
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, this.getGavLabel());
            }
        }
    }

    private void waitForStartedContainer(ServiceHub hub, ExecutorCompletionService<StartedContainer> containerStartupService, Set<String> startedContainerAliases, Queue<ImageConfiguration> imagesStarting) throws InterruptedException, DockerAccessException, IOException, ExecException {
        Future<StartedContainer> startedContainerFuture = containerStartupService.take();
        try {
            StartedContainer startedContainer = startedContainerFuture.get();
            ImageConfiguration imageConfig = startedContainer.imageConfig;
            this.updateAliasesSet(startedContainerAliases, imageConfig.getAlias());
            this.exposeContainerProps(hub.getQueryService(), startedContainer);
            imagesStarting.remove(imageConfig);
        }
        catch (ExecutionException e) {
            this.rethrowCause(e);
        }
    }

    protected Boolean followLogs() {
        return Boolean.valueOf(System.getProperty("docker.follow", "false"));
    }

    private boolean hasBeenAllImagesStarted(Queue<ImageConfiguration> imagesWaitingToStart, Queue<ImageConfiguration> imagesStarting) {
        return imagesWaitingToStart.isEmpty() && imagesStarting.isEmpty();
    }

    private void shutdownExecutorService(ExecutorService executorService) {
        if (!executorService.isShutdown()) {
            executorService.shutdown();
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.log.warn("ExecutorService did not shutdown normally.", new Object[0]);
                executorService.shutdownNow();
            }
        }
    }

    private void rethrowCause(ExecutionException e) throws IOException, InterruptedException, ExecException {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof ExecException) {
            throw (ExecException)cause;
        }
        if (cause instanceof InterruptedException) {
            throw (InterruptedException)cause;
        }
        throw new RuntimeException("Start-Job failed with unexpected exception: " + e.getCause().getMessage(), e.getCause());
    }

    private void updateAliasesSet(Set<String> aliasesSet, String alias) {
        if (alias != null) {
            aliasesSet.add(alias);
        }
    }

    private void startImage(ImageConfiguration imageConfig, ServiceHub hub, ExecutorCompletionService<StartedContainer> startingContainers, PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper) throws IOException {
        RunService runService = hub.getRunService();
        Properties projProperties = this.project.getProperties();
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        PortMapping portMapping = runService.createPortMapping(runConfig, projProperties);
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        StartContainerExecutor startExecutor = new StartContainerExecutor.Builder().dispatcher(dispatcher).follow(this.follow).log(this.log).portMapping(portMapping).gavLabel(this.getGavLabel()).projectProperties(this.project.getProperties()).basedir(this.project.getBasedir()).imageConfig(imageConfig).serviceHub(hub).logOutputSpecFactory(this.serviceHubFactory.getLogOutputSpecFactory()).showLogs(this.showLogs).containerNamePattern(this.containerNamePattern).buildTimestamp(this.getBuildTimestamp()).build();
        startingContainers.submit(() -> {
            portMappingPropertyWriteHelper.add(portMapping, runConfig.getPortPropertyFile());
            String containerId = startExecutor.startContainers();
            return new StartedContainer(imageConfig, containerId);
        });
    }

    private List<ImageConfiguration> getImagesWhoseDependenciesHasStarted(Queue<ImageConfiguration> imagesRemaining, Set<String> containersStarted, Set<String> aliases) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageWaitingToStart : imagesRemaining) {
            List<String> allDependencies = imageWaitingToStart.getDependencies();
            List<String> aliasDependencies = this.filterOutNonAliases(aliases, allDependencies);
            if (!containersStarted.containsAll(aliasDependencies)) continue;
            ret.add(imageWaitingToStart);
        }
        return ret;
    }

    private Queue<ImageConfiguration> prepareStart(ServiceHub hub, QueryService queryService, RunService runService, Set<String> imageAliases) throws DockerAccessException, MojoExecutionException {
        ArrayDeque<ImageConfiguration> imagesWaitingToStart = new ArrayDeque<ImageConfiguration>();
        for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getResolvedImages())) {
            ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
            RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
            RegistryService.RegistryConfig registryConfig = this.getRegistryConfig(this.pullRegistry);
            ImagePullManager pullManager = this.getImagePullManager(this.determinePullPolicy(runConfig), this.autoPull);
            hub.getRegistryService().pullImageWithPolicy(imageConfig.getName(), pullManager, registryConfig, queryService.hasImage(imageConfig.getName()));
            NetworkConfig config = runConfig.getNetworkingConfig();
            List<String> bindMounts = this.extractBindMounts(runConfig.getVolumeConfiguration());
            if (!bindMounts.isEmpty()) {
                List<VolumeConfiguration> volumes = this.getVolumes();
                runService.createVolumesAsPerVolumeBinds(hub, bindMounts, volumes);
            }
            if (this.autoCreateCustomNetworks && config.isCustomNetwork()) {
                runService.createCustomNetworkIfNotExistant(config.getCustomNetwork());
            }
            imagesWaitingToStart.add(imageConfig);
            this.updateAliasesSet(imageAliases, imageConfig.getAlias());
        }
        return imagesWaitingToStart;
    }

    private List<String> extractBindMounts(RunVolumeConfiguration volumeConfiguration) {
        if (volumeConfiguration == null) {
            return Collections.emptyList();
        }
        return volumeConfiguration.getBind() != null ? volumeConfiguration.getBind() : Collections.emptyList();
    }

    private String determinePullPolicy(RunImageConfiguration runConfig) {
        return runConfig.getImagePullPolicy() != null ? runConfig.getImagePullPolicy() : this.imagePullPolicy;
    }

    private List<String> filterOutNonAliases(Set<String> imageAliases, List<String> dependencies) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String alias : dependencies) {
            if (!imageAliases.contains(alias)) continue;
            ret.add(alias);
        }
        return ret;
    }

    private ExecutorService getExecutorService() {
        ExecutorService executorService = this.startParallel ? Executors.newCachedThreadPool() : MoreExecutors.newDirectExecutorService();
        return executorService;
    }

    private void exposeContainerProps(QueryService queryService, StartedContainer startedContainer) throws DockerAccessException {
        String propKey = this.getExposedPropertyKeyPart(startedContainer.imageConfig);
        if (StringUtils.isNotEmpty((String)this.exposeContainerProps) && StringUtils.isNotEmpty((String)propKey)) {
            Map<String, String> nets;
            Container container = queryService.getMandatoryContainer(startedContainer.containerId);
            Properties props = this.project.getProperties();
            String prefix = this.addDot(this.exposeContainerProps) + this.addDot(propKey);
            props.put(prefix + "id", startedContainer.containerId);
            String ip = container.getIPAddress();
            if (StringUtils.isNotEmpty((String)ip)) {
                props.put(prefix + "ip", ip);
            }
            if ((nets = container.getCustomNetworkIpAddresses()) != null) {
                for (Map.Entry<String, String> entry : nets.entrySet()) {
                    props.put(prefix + this.addDot("net") + this.addDot(entry.getKey()) + "ip", entry.getValue());
                }
            }
        }
    }

    private String getExposedPropertyKeyPart(ImageConfiguration image) {
        String propKey;
        String string = propKey = image.getRunConfiguration() != null ? image.getRunConfiguration().getExposedPropertyKey() : null;
        if (StringUtils.isEmpty((String)propKey)) {
            propKey = image.getAlias();
        }
        return propKey;
    }

    private String addDot(String part) {
        return part.endsWith(".") ? part : part + ".";
    }

    private static final class StartedContainer {
        public final ImageConfiguration imageConfig;
        public final String containerId;

        private StartedContainer(ImageConfiguration imageConfig, String containerId) {
            this.imageConfig = imageConfig;
            this.containerId = containerId;
        }
    }
}

