/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.util.ExternalCommand;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.JsonFactory;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class CredentialHelperClient {
    static final String SECRET_KEY = "Secret";
    static final String USERNAME_KEY = "Username";
    private final String credentialHelperName;
    private final Logger log;

    public CredentialHelperClient(Logger log, String credentialsStore) {
        this.log = log;
        this.credentialHelperName = "docker-credential-" + credentialsStore;
    }

    public String getName() {
        return this.credentialHelperName;
    }

    public String getVersion() throws MojoExecutionException {
        try {
            return new VersionCommand().getVersion();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting the version of the configured credential helper", (Exception)e);
        }
    }

    public AuthConfig getAuthConfig(String registryToLookup) throws MojoExecutionException {
        try {
            GetCommand getCommand = new GetCommand();
            return this.toAuthConfig(getCommand.getCredentialNode(EnvUtil.ensureRegistryHttpUrl(registryToLookup)));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting the credentials for " + registryToLookup + " from the configured credential helper", (Exception)e);
        }
    }

    private AuthConfig toAuthConfig(JsonObject credential) {
        if (credential == null) {
            return null;
        }
        String password = credential.get(SECRET_KEY).getAsString();
        String userKey = credential.get(USERNAME_KEY).getAsString();
        return new AuthConfig(userKey, password, null, null);
    }

    private class GetCommand
    extends ExternalCommand {
        private List<String> reply;

        GetCommand() {
            super(CredentialHelperClient.this.log);
            this.reply = Lists.newLinkedList();
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "get"};
        }

        @Override
        protected void processLine(String line) {
            this.reply.add(line);
        }

        public JsonObject getCredentialNode(String registryToLookup) throws IOException {
            try {
                this.execute(registryToLookup);
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    return null;
                }
                throw ex;
            }
            JsonObject credentials = JsonFactory.newJsonObject(Joiner.on((char)'\n').join(this.reply));
            if (!credentials.has(CredentialHelperClient.SECRET_KEY) || !credentials.has(CredentialHelperClient.USERNAME_KEY)) {
                return null;
            }
            return credentials;
        }
    }

    private class VersionCommand
    extends ExternalCommand {
        private String version;

        VersionCommand() {
            super(CredentialHelperClient.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "version"};
        }

        @Override
        protected void processLine(String line) {
            this.log.verbose("Credentials helper reply for \"%s\" is %s", CredentialHelperClient.this.credentialHelperName, line);
            this.version = line;
        }

        public String getVersion() throws IOException {
            this.execute();
            if (this.version == null) {
                this.log.verbose("The credentials helper \"%s\" didn't return a version string", CredentialHelperClient.this.credentialHelperName);
            }
            return this.version;
        }
    }
}

