/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.assembly.DockerAssemblyConfigurationSource;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.io.DefaultAssemblyReader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;

public class DockerFileUtil {
    private DockerFileUtil() {
    }

    public static String extractBaseImage(File dockerFile, FixedStringSearchInterpolator interpolator) throws IOException {
        String[] parts;
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", interpolator);
        if (!fromLines.isEmpty() && (parts = fromLines.get(0)).length > 1) {
            return parts[1];
        }
        return null;
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, FixedStringSearchInterpolator interpolator) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = interpolator.interpolate(line);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, FixedStringSearchInterpolator interpolator) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(interpolator.interpolate(line)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    public static FixedStringSearchInterpolator createInterpolator(MojoParameters params, String filter) {
        String[] delimiters = DockerFileUtil.extractDelimiters(filter);
        if (delimiters == null) {
            return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[0]);
        }
        DockerAssemblyConfigurationSource configSource = new DockerAssemblyConfigurationSource(params, null, null);
        return AssemblyInterpolator.fullInterpolator((MavenProject)params.getProject(), (FixedStringSearchInterpolator)DefaultAssemblyReader.createProjectInterpolator((MavenProject)params.getProject()), (AssemblerConfigurationSource)configSource).withExpressionMarkers(delimiters[0], delimiters[1]);
    }

    public static String getDockerFileDirectory(String projectBaseDirPath) {
        if (DockerFileUtil.checkFileExists(projectBaseDirPath + "/Dockerfile")) {
            return projectBaseDirPath;
        }
        if (DockerFileUtil.checkFileExists(projectBaseDirPath + "/src/main/docker/Dockerfile")) {
            return projectBaseDirPath + "/src/main/docker";
        }
        throw new IllegalStateException("Unable to locate Dockerfile");
    }

    private static boolean checkFileExists(String filePath) {
        File aFile = new File(filePath);
        return aFile.exists() && !aFile.isDirectory();
    }

    private static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return null;
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }
}

